/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.FloatValidator;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractListWidget;
import java.util.Collection;
import javax.swing.Action;

public class FloatListWidget
extends AbstractListWidget {
    private static final long serialVersionUID = 3428837978085767231L;

    private Action getCreateAction() {
        return new CreateAction(ResourceKey.VALUE_ADD){
            private static final long serialVersionUID = -8103626732943969984L;

            public void onCreate() {
                String s = DisplayUtilities.editString(FloatListWidget.this, "Create Float Value", null, new FloatValidator());
                if (s != null) {
                    FloatListWidget.this.addItem(new Float(s));
                }
            }
        };
    }

    private Action getDeleteAction() {
        return new RemoveAction(ResourceKey.VALUE_REMOVE, (Selectable)this){
            private static final long serialVersionUID = -5242502708398191556L;

            public void onRemove(Collection elements) {
                FloatListWidget.this.removeItems(elements);
            }
        };
    }

    private Action getEditAction() {
        return new ViewAction(ResourceKey.VALUE_VIEW, (Selectable)this){
            private static final long serialVersionUID = 1016994137862284684L;

            public void onView(Object o) {
                String s = DisplayUtilities.editString(FloatListWidget.this, "Edit Float Value", o.toString(), null);
                if (s != null) {
                    FloatListWidget.this.replaceItem(o, new Float(s));
                }
            }
        };
    }

    public void initialize() {
        Action editAction = this.getEditAction();
        super.initialize(editAction);
        this.addButton(editAction);
        this.addButton(this.getCreateAction());
        this.addButton(this.getDeleteAction());
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean isSuitable;
        if (cls == null || slot == null) {
            isSuitable = false;
        } else {
            boolean isFloat = cls.getTemplateSlotValueType(slot) == ValueType.FLOAT;
            boolean isMultiple = cls.getTemplateSlotAllowsMultipleValues(slot);
            isSuitable = isFloat && isMultiple;
        }
        return isSuitable;
    }
}

