/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.KnowledgeBaseAdapter;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.ResizingLayout;
import edu.stanford.smi.protege.util.UnaryFunction;
import edu.stanford.smi.protege.widget.AbstractClsWidget;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.DefaultWidgetLayoutStrategy;
import edu.stanford.smi.protege.widget.FormWidgetConfigurationPanel;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protege.widget.Widget;
import edu.stanford.smi.protege.widget.WidgetLayoutStrategy;
import edu.stanford.smi.protege.widget.WidgetUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class FormWidget
extends AbstractClsWidget {
    private static final long serialVersionUID = 3570021442107936448L;
    public static final String STRETCH_ALL = "<<all>>";
    public static final String STRETCH_NONE = "<<none>>";
    private static final String PROPERTY_LAYOUT_PROPERTIES = "layout properties";
    private static final String PROPERTY_HORIZONTAL_STRETCHER = "horizontal_stretcher";
    private static final String PROPERTY_VERTICAL_STRETCHER = "vertical_stretcher";
    private static final int RESIZE_NONE = 0;
    private static final int RESIZE_NW = 6;
    private static final int RESIZE_N = 8;
    private static final int RESIZE_NE = 7;
    private static final int RESIZE_E = 11;
    private static final int RESIZE_SE = 5;
    private static final int RESIZE_S = 9;
    private static final int RESIZE_SW = 4;
    private static final int RESIZE_W = 10;
    private WidgetLayoutStrategy _cachedLayoutStrategy = new DefaultWidgetLayoutStrategy();
    private AbstractSlotWidget _selectedWidget;
    private Dimension _cursorOffset;
    private int _resizeDirection = 0;
    private int _gridSize = 10;
    private boolean _isDragging;
    private KeyListener _widgetKeyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent event) {
            Component c = event.getComponent();
            int key = event.getKeyCode();
            switch (key) {
                case 37: {
                    FormWidget.this.translate(c, -1, 0);
                    break;
                }
                case 39: {
                    FormWidget.this.translate(c, 1, 0);
                    break;
                }
                case 38: {
                    FormWidget.this.translate(c, 0, -1);
                    break;
                }
                case 40: {
                    FormWidget.this.translate(c, 0, 1);
                    break;
                }
            }
        }
    };
    private MouseListener _formMouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            FormWidget.this.mousePressedOnForm(e.getPoint());
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                FormWidget.this.configure();
            }
        }
    };
    private MouseMotionListener _formMouseMotionListener = new MouseMotionAdapter(){

        public void mouseMoved(MouseEvent e) {
            FormWidget.this.mouseMovedOnForm(e.getPoint());
        }
    };
    private MouseListener _widgetMouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            FormWidget.this.mousePressedOnWidget(e.getComponent(), e.getPoint());
        }

        public void mouseReleased(MouseEvent e) {
            FormWidget.this.mouseReleasedOnWidget(e.getComponent(), e.getPoint());
        }

        public void mouseClicked(MouseEvent e) {
            FormWidget.this.mouseClickedOnWidget(e.getComponent(), e.getPoint(), e.getClickCount());
        }
    };
    private MouseMotionListener _widgetMouseMotionListener = new MouseMotionListener(){

        public void mouseDragged(MouseEvent e) {
            FormWidget.this.mouseDraggedOnWidget(e.getComponent(), e.getPoint());
        }

        public void mouseMoved(MouseEvent e) {
            FormWidget.this.mouseMovedOnWidget(e.getComponent(), e.getPoint());
        }
    };
    private ClsListener _clsListener = new ClsAdapter(){

        public void templateSlotAdded(ClsEvent event) {
            if (FormWidget.this.canChangeThisClass(event.getCls())) {
                FormWidget.this.onTemplateSlotAdded(event.getCls(), event.getSlot());
            }
        }

        public void templateSlotRemoved(ClsEvent event) {
            if (FormWidget.this.canChangeThisClass(event.getCls())) {
                FormWidget.this.onTemplateSlotRemoved(event.getCls(), event.getSlot());
            }
        }

        public void templateFacetValueChanged(ClsEvent event) {
            if (FormWidget.this.canChangeThisClass(event.getCls())) {
                FormWidget.this.onTemplateFacetValueChanged(event.getCls(), event.getSlot(), event.getFacet());
            }
        }
    };
    private KnowledgeBaseListener _kbListener = new KnowledgeBaseAdapter(){

        public void frameReplaced(KnowledgeBaseEvent event) {
            Frame frame = event.getFrame();
            if (frame instanceof Slot) {
                Slot slot = (Slot)frame;
                WidgetDescriptor d = FormWidget.this.getPropertyList().getWidgetDescriptor(event.getOldName());
                if (d != null) {
                    d.setName(event.getNewFrame().getName());
                    FormWidget.this.reload();
                }
            }
        }
    };

    protected void onTemplateSlotAdded(Cls cls, Slot slot) {
        this.reload();
    }

    protected void onTemplateSlotRemoved(Cls cls, Slot slot) {
        this.reload();
    }

    protected void onTemplateFacetValueChanged(Cls cls, Slot slot, Facet facet) {
        this.reload();
    }

    private boolean canChangeThisClass(Cls cls) {
        Cls currentCls = this.getCls();
        return currentCls.equals(cls) || currentCls.hasSuperclass(cls);
    }

    private static void adjustEast(Rectangle r, Point p) {
        r.width -= r.x + r.width - p.x;
    }

    private static void adjustNorth(Rectangle r, Point p) {
        r.height += r.y - p.y;
        r.y = p.y;
    }

    private static void adjustSouth(Rectangle r, Point p) {
        r.height -= r.y + r.height - p.y;
    }

    private static void adjustWest(Rectangle r, Point p) {
        r.width += r.x - p.x;
        r.x = p.x;
    }

    private boolean canRemoveCustomizations() {
        FrameID id = this.getCls().getFrameID();
        return !FormWidget.equals(id, Model.ClsID.STANDARD_CLASS) && !FormWidget.equals(id, Model.ClsID.STANDARD_SLOT);
    }

    public void clearSelection() {
        if (this._selectedWidget != null) {
            this._selectedWidget.setNormalBorder();
            this._selectedWidget = null;
            this.notifySelectionListeners();
        }
    }

    public boolean configure() {
        boolean configured;
        FormWidgetConfigurationPanel p = new FormWidgetConfigurationPanel(this);
        int result = ModalDialog.showDialog(this, p, "Configure form for " + this.getCls().getName(), 11);
        boolean bl = configured = result == 1;
        if (configured) {
            this.setModified(true);
        }
        return configured;
    }

    public void createDescriptorsAndWidgets(Collection slots) {
        for (Slot slot : slots) {
            this.createWidget(slot);
        }
    }

    private Widget createWidget(Slot slot) {
        return this.createWidget(slot, null);
    }

    private Widget createWidget(Slot slot, String widgetClassName) {
        WidgetDescriptor d = this.createWidgetDescriptor(slot);
        if (widgetClassName != null) {
            d.setWidgetClassName(widgetClassName);
        }
        return this.createWidget(d);
    }

    private SlotWidget createWidget(WidgetDescriptor descriptor) {
        SlotWidget widget;
        if (descriptor.isNull()) {
            widget = null;
        } else {
            KnowledgeBase kb = this.getKnowledgeBase();
            String slotName = descriptor.getName();
            Slot slot = kb.getSlot(slotName);
            widget = WidgetUtilities.createSlotWidget(descriptor, this.isDesignTime(), this.getProject(), this.getCls(), slot);
            this.setupWidget(widget);
        }
        return widget;
    }

    public WidgetDescriptor createWidgetDescriptor(Slot slot) {
        WidgetDescriptor d = this.getProject().createWidgetDescriptor(this.getCls(), slot, null);
        this.getPropertyList().setWidgetDescriptor(d);
        return d;
    }

    protected Collection getClsSlots() {
        Slot nameSlot;
        Collection templateSlots = this.getCls().getVisibleTemplateSlots();
        if (this.getProject().getAddNameOnInstanceForm() && !templateSlots.contains(nameSlot = this.getKnowledgeBase().getNameSlot())) {
            templateSlots.add(nameSlot);
        }
        return templateSlots;
    }

    protected void createWidgets() {
        HashSet slots = new HashSet(this.getClsSlots());
        for (String name : this.getPropertyList().getNames()) {
            WidgetDescriptor descriptor;
            if (name == null) {
                Log.getLogger().warning("null widget name");
                continue;
            }
            if (!FormWidget.isSlotName(name) || (descriptor = this.getPropertyList().getWidgetDescriptor(name)) == null) continue;
            String slotName = descriptor.getName();
            if (!name.equals(slotName)) {
                Log.getLogger().warning("Mismatched slot names: " + name + " - " + slotName);
            }
            boolean succeeded = true;
            if (slotName != null) {
                Slot slot = this.getKnowledgeBase().getSlot(slotName);
                if (slot != null) {
                    succeeded = this.isSuitable(descriptor, this.getCls(), slot);
                }
                if (succeeded) {
                    succeeded = slots.remove(slot);
                }
            }
            if (succeeded) {
                this.createWidget(descriptor);
                continue;
            }
            this.getPropertyList().remove(name);
        }
        int startIndex = this.getCustomizedComponentCount();
        this.createDescriptorsAndWidgets(slots);
        this.layoutWidgets(startIndex);
        this.doLayoutSanityCheck();
    }

    public void dispose() {
        super.dispose();
        this.getKnowledgeBase().removeKnowledgeBaseListener(this._kbListener);
        if (this.isDesignTime()) {
            this.removeMouseListener(this._formMouseListener);
            this.removeMouseMotionListener(this._formMouseMotionListener);
            this.getKnowledgeBase().removeClsListener(this._clsListener);
        }
    }

    private void doLayoutSanityCheck() {
        boolean topLeftAlreadyPresent = false;
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = this.getComponent(i);
            Point p = c.getLocation();
            if (p.x != 0 || p.y != 0) continue;
            if (topLeftAlreadyPresent) {
                c.setLocation(0, this.getPreferredSize().height);
                this.revalidate();
                continue;
            }
            topLeftAlreadyPresent = true;
        }
    }

    private void dragWidget(JComponent widget, Point point) {
        point.translate(this._cursorOffset.width, this._cursorOffset.height);
        Point gridPoint = this.gridPoint(point);
        if (!gridPoint.equals(widget.getLocation())) {
            widget.setLocation(gridPoint);
        }
    }

    private Component getComponent(Slot slot) {
        Component component = null;
        int nComponents = this.getComponentCount();
        for (int i = 0; i < nComponents; ++i) {
            SlotWidget w;
            Component c = this.getComponent(i);
            if (!(c instanceof SlotWidget) || !FormWidget.equals((w = (SlotWidget)((Object)c)).getSlot(), slot)) continue;
            component = c;
            break;
        }
        return component;
    }

    private int getCustomizedComponentCount() {
        return this.getComponentCount();
    }

    protected Cls getCustomizedParent(Cls cls) {
        Cls customizedParent;
        block0: {
            Project project = cls.getProject();
            customizedParent = null;
            Iterator<Cls> i = cls.getDirectSuperclasses().iterator();
            if (!i.hasNext() || customizedParent != null) break block0;
            Cls parent = i.next();
            customizedParent = project.hasCustomizedDescriptor(parent) ? parent : this.getCustomizedParent(parent);
        }
        return customizedParent;
    }

    public String getHorizontalStretcher() {
        return this.getLayout(PROPERTY_HORIZONTAL_STRETCHER);
    }

    public String getLabel() {
        String label;
        if (this.isDesignTime()) {
            label = this.getCls().getBrowserText();
        } else {
            String browserText;
            Instance instance = this.getInstance();
            label = browserText = instance.getBrowserText();
            Cls cls = this.getAssociatedCls();
            if (instance instanceof Slot && cls != null) {
                label = label + " at class " + cls.getBrowserText();
            }
            label = label + "   (instance of " + instance.getDirectType().getBrowserText();
            String instanceName = instance.getName();
            if (!instanceName.equals(browserText)) {
                label = label + ", internal name is " + instanceName;
            }
            label = label + ")";
        }
        return label;
    }

    private PropertyList getLayoutProperties() {
        return this.getPropertyList().getPropertyList(PROPERTY_LAYOUT_PROPERTIES);
    }

    private String getLayout(String propertyName) {
        return this.getLayoutProperties().getString(propertyName);
    }

    private Point getParentPoint(Point p) {
        return SwingUtilities.convertPoint(this, p, this.getParent());
    }

    public Dimension getPreferredSize() {
        Dimension preferredSize = new Dimension();
        for (WidgetDescriptor descriptor : this.getPropertyList().getLiveWidgetDescriptors()) {
            String widgetName = descriptor.getName();
            if (!FormWidget.isSlotName(widgetName) || descriptor.isNull()) continue;
            Rectangle r = descriptor.getBounds();
            if (r == null) {
                Log.getLogger().warning("null rectangle: " + widgetName);
                continue;
            }
            preferredSize.width = Math.max(preferredSize.width, r.x + r.width);
            preferredSize.height = Math.max(preferredSize.height, r.y + r.height);
        }
        return preferredSize;
    }

    private static int getResizeDirection(Component c, Point p) {
        int direction;
        Rectangle outerRect = c.getBounds();
        Rectangle innerRect = new Rectangle(outerRect);
        int BORDER_SIZE = AbstractSlotWidget.getSelectionBorderSize();
        innerRect.grow(-BORDER_SIZE, -BORDER_SIZE);
        if (innerRect.contains(p)) {
            direction = 0;
        } else if (p.x <= innerRect.x) {
            direction = p.y <= innerRect.y ? 6 : (p.y >= innerRect.y + innerRect.height ? 4 : 10);
        } else if (p.x >= innerRect.x + innerRect.width) {
            direction = p.y <= innerRect.y ? 7 : (p.y >= innerRect.y + innerRect.height ? 5 : 11);
        } else if (p.y <= innerRect.y) {
            direction = 8;
        } else if (p.y >= innerRect.y + innerRect.height) {
            direction = 9;
        } else {
            throw new IllegalStateException("Logic error on resize direction");
        }
        return direction;
    }

    public Collection getSelection() {
        return CollectionUtilities.createCollection(this._selectedWidget);
    }

    public String getVerticalStretcher() {
        return this.getLayout(PROPERTY_VERTICAL_STRETCHER);
    }

    public SlotWidget getSlotWidget(Slot slot) {
        int componentCount = this.getComponentCount();
        SlotWidget widget = null;
        for (int i = 0; i < componentCount; ++i) {
            SlotWidget w;
            Component c = this.getComponent(i);
            if (!(c instanceof Widget) || !FormWidget.equals((w = (SlotWidget)((Object)c)).getSlot(), slot)) continue;
            widget = w;
            break;
        }
        return widget;
    }

    public void highlightSlot(Slot slot, Color color) {
        AbstractSlotWidget widget = (AbstractSlotWidget)this.getSlotWidget(slot);
        if (widget != null) {
            if (color == null) {
                widget.setNormalBorder();
            } else {
                widget.setSelectedBorder(color);
            }
        }
    }

    private JComponent getWidget(Component descendent) {
        JComponent widget = null;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            JComponent c = (JComponent)this.getComponent(i);
            if (!FormWidget.equals(c, descendent) && !c.isAncestorOf(descendent)) continue;
            widget = c;
            break;
        }
        Assert.assertNotNull("widget", widget);
        return widget;
    }

    public WidgetDescriptor getWidgetDescriptor(Slot slot) {
        return this.getPropertyList().getWidgetDescriptor(slot.getName());
    }

    private Point getWidgetPoint(Component c, Point p) {
        return SwingUtilities.convertPoint(c, p, this);
    }

    private Point gridPoint(Point p) {
        Point gridPoint = new Point(p);
        gridPoint.x -= gridPoint.x % this._gridSize;
        gridPoint.y -= gridPoint.y % this._gridSize;
        return gridPoint;
    }

    public boolean hasWidgetDescriptor(Slot slot) {
        return this.getWidgetDescriptor(slot) != null;
    }

    public boolean hasWidgetDescriptors() {
        boolean b = !this.getPropertyList().getNames().isEmpty();
        return b;
    }

    public void setResizeVertically(boolean b) {
        LayoutManager manager = this.getLayout();
        if (manager instanceof ResizingLayout) {
            ((ResizingLayout)manager).setResizeVertically(b);
        }
    }

    public void initialize() {
        this.setLayout(null);
        this.initializeStretching();
        this.initializeWidgets();
        this.getKnowledgeBase().addKnowledgeBaseListener(this._kbListener);
        if (this.isDesignTime()) {
            this.addMouseListener(this._formMouseListener);
            this.addMouseMotionListener(this._formMouseMotionListener);
            this.getKnowledgeBase().addClsListener(this._clsListener);
        } else {
            this.setLayout(new ResizingLayout());
        }
    }

    public void reload() {
        Component[] components = this.getComponents();
        this.removeAll();
        for (int i = 0; i < components.length; ++i) {
            ComponentUtilities.dispose(components[i]);
        }
        this.initializeWidgets();
    }

    private void initializeStretching() {
        String horizontalValue = this.getHorizontalStretcher();
        this.putStretchingClientProperty("filling_horizontally", horizontalValue, true);
        String verticalValue = this.getVerticalStretcher();
        this.putStretchingClientProperty("filling_vertically", verticalValue, false);
    }

    private void putStretchingClientProperty(String propertyName, String value, boolean defaultValue) {
        boolean booleanValue = value == null ? defaultValue : !STRETCH_NONE.equals(value);
        this.putClientProperty(propertyName, booleanValue);
    }

    private void initializeWidgets() {
        if (this.isDesignTime() && !this.isModified()) {
            Cls parent = this.getCustomizedParent(this.getCls());
            if (parent != null) {
                this.layoutLikeCls(parent);
                this.setModified(false);
            } else {
                this.createWidgets();
            }
        } else {
            this.createWidgets();
        }
    }

    private boolean isModified() {
        return this.getDescriptor().isDirectlyCustomizedByUser();
    }

    private static boolean isSlotName(String name) {
        return !name.equals(PROPERTY_LAYOUT_PROPERTIES);
    }

    protected boolean isSuitable(WidgetDescriptor d, Cls cls, Slot slot) {
        String className = d.getWidgetClassName();
        return className == null || this.getProject().isSuitableWidget(cls, slot, null, d);
    }

    public void layoutLikeCls(Cls prototype) {
        this.removeAllSlotWidgets();
        PropertyList list = this.getProject().getClsWidgetPropertyList(prototype);
        this.setPropertyList((PropertyList)list.clone());
        this.setModified(true);
        this.createWidgets();
        this.revalidate();
        this.repaint();
    }

    public void layoutLikeParent() {
        Cls parent = this.getCustomizedParent(this.getCls());
        this.layoutLikeCls(parent);
        this.setModified(false);
    }

    private void layoutWidgets(int fromIndex) {
        if (fromIndex < this.getComponentCount()) {
            this._cachedLayoutStrategy.layout(this, fromIndex);
        }
        this.revalidate();
        this.repaint();
    }

    private void mouseClickedOnWidget(Component c, Point p, int clickCount) {
        Widget widget;
        boolean changed;
        if (clickCount == 2 && (changed = (widget = (Widget)((Object)this.getWidget(c))).configure())) {
            this.rebuildWidget(widget);
        }
    }

    private void mouseDrag(JComponent c, Point p) {
        if (this._resizeDirection == 0) {
            this.dragWidget(c, p);
        } else {
            this.resizeWidget(c, p);
        }
        this.updateSize();
    }

    public void mouseDraggedOnWidget(Component c, Point p) {
        JComponent widget = this.getWidget(c);
        Point point = this.getWidgetPoint(c, p);
        this.mouseDrag(widget, point);
        this._isDragging = true;
    }

    private void mouseMove(JComponent c, Point p) {
        this.setCursor(c, p);
    }

    private void mouseMovedOnForm(Point point) {
        int dir;
        Point p = this.getParentPoint(point);
        this._resizeDirection = dir = FormWidget.getResizeDirection(this, p);
        this.setCursor((Component)this, dir);
    }

    public void mouseMovedOnWidget(Component c, Point p) {
        JComponent widget = this.getWidget(c);
        Point point = this.getWidgetPoint(c, p);
        this.mouseMove(widget, point);
    }

    private void mousePress(JComponent c, Point p) {
        if (c != this._selectedWidget) {
            this.clearSelection();
            this.setSelection(c);
        }
        Point topLeft = c.getLocation();
        this._cursorOffset = new Dimension(topLeft.x - p.x, topLeft.y - p.y);
        this._resizeDirection = FormWidget.getResizeDirection(c, p);
        c.requestFocus();
    }

    private void mousePressedOnForm(Point point) {
        this.clearSelection();
        this.repaint();
    }

    private void mousePressedOnWidget(Component c, Point p) {
        JComponent widget = this.getWidget(c);
        Point point = this.getWidgetPoint(c, p);
        this.mousePress(widget, point);
    }

    private void mouseRelease(JComponent c, Point p) {
        this._resizeDirection = 0;
        this.setCursor(c, p);
    }

    private void mouseReleasedOnWidget(Component c, Point p) {
        JComponent widget = this.getWidget(c);
        Point point = this.getWidgetPoint(c, p);
        this.mouseRelease(widget, point);
        if (this._isDragging) {
            this._isDragging = false;
            this.setModified(true);
        }
    }

    private void propagateSetAssociatedClsToWidgets(Cls associatedCls) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            if (!(c instanceof Widget)) continue;
            SlotWidget widget = (SlotWidget)((Object)c);
            widget.setAssociatedCls(associatedCls);
        }
    }

    private void propagateSetInstanceToWidgets(Instance instance) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            if (!(c instanceof Widget)) continue;
            SlotWidget widget = (SlotWidget)((Object)c);
            widget.setInstance(instance);
        }
    }

    private void rebuildWidget(Widget widget) {
        this.replaceWidget((Component)((Object)widget), widget.getClass().getName());
        this.setModified(true);
    }

    public void relayout() {
        this.layoutWidgets(0);
        this.setModified(true);
    }

    public void removeCustomizations() {
        if (this.canRemoveCustomizations()) {
            this.getPropertyList().clear();
            this.setModified(false);
            this.removeAll();
            this.initializeWidgets();
            this.revalidate();
            this.repaint();
        } else {
            Log.getLogger().warning("cannot remove customizations for " + this.getCls());
        }
    }

    private void removeAllSlotWidgets() {
        ArrayList<Component> components = new ArrayList<Component>(Arrays.asList(this.getComponents()));
        for (Component c : components) {
            if (!(c instanceof Widget)) continue;
            SlotWidget w = (SlotWidget)((Object)c);
            this.removeSlotWidget(w);
        }
        this.removeAll();
    }

    private void removeSlotWidget(SlotWidget widget) {
        Component c = (Component)((Object)widget);
        this.remove(c);
        if (this._selectedWidget == widget) {
            this.clearSelection();
        }
        if (this.isDesignTime()) {
            c.removeMouseListener(this._widgetMouseListener);
            c.removeMouseMotionListener(this._widgetMouseMotionListener);
            c.removeKeyListener(this._widgetKeyListener);
        }
        widget.dispose();
    }

    public void removeWidgetDescriptor(String slotName) {
        this.getPropertyList().remove(slotName);
    }

    public void replaceSelectedWidget(String newWidgetClassName) {
        this.replaceWidget(this._selectedWidget, newWidgetClassName);
        this.setModified(true);
    }

    public void replaceWidget(Slot slot, String newWidgetClassName) {
        WidgetDescriptor d = this.getWidgetDescriptor(slot);
        if (d == null) {
            if (newWidgetClassName != null) {
                this.createWidget(slot, newWidgetClassName);
            }
        } else {
            String oldWidgetClassName = d.getWidgetClassName();
            if (oldWidgetClassName == null) {
                if (newWidgetClassName != null) {
                    int startIndex = this.getCustomizedComponentCount();
                    d.setWidgetClassName(newWidgetClassName);
                    d.setBounds(new Rectangle());
                    this.createWidget(d);
                    this.layoutWidgets(startIndex);
                }
            } else if (!oldWidgetClassName.equals(newWidgetClassName)) {
                this.replaceWidget(this.getComponent(slot), newWidgetClassName);
            }
        }
    }

    private void replaceWidget(Component oldComponent, String newClassName) {
        if (oldComponent == null) {
            return;
        }
        Rectangle bounds = oldComponent.getBounds();
        Dimension oldPreferredSize = oldComponent.getPreferredSize();
        this.remove(oldComponent);
        SlotWidget oldWidget = (SlotWidget)((Object)oldComponent);
        WidgetDescriptor descriptor = oldWidget.getDescriptor();
        descriptor.setWidgetClassName(newClassName);
        descriptor.setBounds(new Rectangle());
        ComponentUtilities.dispose(oldComponent);
        if (newClassName == null) {
            if (this._selectedWidget == oldComponent) {
                this.clearSelection();
                this.revalidate();
                this.repaint();
            }
        } else {
            Dimension newPreferredSize;
            SlotWidget widget = WidgetUtilities.createSlotWidget(descriptor, true, this.getProject(), this.getCls(), oldWidget.getSlot());
            this.setupWidget(widget);
            if (this._selectedWidget == oldComponent) {
                this.setSelection(widget);
            }
            if ((newPreferredSize = ((JComponent)((Object)widget)).getPreferredSize()).equals(oldPreferredSize) || oldWidget.getClass().getName().equals(newClassName)) {
                ((JComponent)((Object)widget)).setBounds(bounds);
            } else {
                ((JComponent)((Object)widget)).setBounds(new Rectangle(bounds.getLocation(), newPreferredSize));
            }
            ((JComponent)((Object)widget)).revalidate();
        }
    }

    private void resizeWidget(Component widget, Point p) {
        p = this.gridPoint(p);
        Rectangle r = widget.getBounds();
        switch (this._resizeDirection) {
            case 8: {
                FormWidget.adjustNorth(r, p);
                break;
            }
            case 9: {
                FormWidget.adjustSouth(r, p);
                break;
            }
            case 11: {
                FormWidget.adjustEast(r, p);
                break;
            }
            case 10: {
                FormWidget.adjustWest(r, p);
                break;
            }
            case 6: {
                FormWidget.adjustNorth(r, p);
                FormWidget.adjustWest(r, p);
                break;
            }
            case 7: {
                FormWidget.adjustNorth(r, p);
                FormWidget.adjustEast(r, p);
                break;
            }
            case 4: {
                FormWidget.adjustSouth(r, p);
                FormWidget.adjustWest(r, p);
                break;
            }
            case 5: {
                FormWidget.adjustSouth(r, p);
                FormWidget.adjustEast(r, p);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid resize direction");
            }
        }
        widget.setBounds(r);
        widget.validate();
        widget.repaint();
    }

    public void setAssociatedCls(Cls associatedCls) {
        super.setAssociatedCls(associatedCls);
        this.propagateSetAssociatedClsToWidgets(associatedCls);
    }

    private void setCursor(Component c, int direction) {
        c.setCursor(Cursor.getPredefinedCursor(direction));
        this.repaint();
    }

    private void setCursor(JComponent c, Point p) {
        if (c == this._selectedWidget) {
            int direction = FormWidget.getResizeDirection(c, p);
            this.setCursor((Component)c, direction);
        } else {
            this.setCursor((Component)c, 0);
        }
    }

    public void setEditable(boolean b) {
    }

    public void setHorizontalStretcher(String hs) {
        this.setLayout(PROPERTY_HORIZONTAL_STRETCHER, hs);
    }

    public void setInstance(Instance instance) {
        super.setInstance(instance);
        this.propagateSetInstanceToWidgets(instance);
    }

    private void setLayout(String propertyName, String sn) {
        this.getLayoutProperties().setString(propertyName, sn);
    }

    public void setModified(boolean b) {
        this.getDescriptor().setDirectlyCustomizedByUser(b);
        this.getDescriptor().setIncluded(false);
        this.getProject().postFormChangeEvent(this.getDescriptor());
    }

    public void setSelection(Object o) {
        this._selectedWidget = (AbstractSlotWidget)o;
        this.remove(this._selectedWidget);
        this.add((Component)this._selectedWidget, 0);
        this._selectedWidget.setSelectedBorder();
        this.notifySelectionListeners();
        this.repaint();
    }

    private void setupWidget(final SlotWidget widget) {
        JComponent component = (JComponent)((Object)widget);
        if (this.isDesignTime()) {
            ComponentUtilities.apply(component, new UnaryFunction(){

                public Object apply(Object o) {
                    Component c = (Component)o;
                    if (c != widget) {
                        c.setEnabled(false);
                    }
                    c.addMouseListener(FormWidget.this._widgetMouseListener);
                    c.addMouseMotionListener(FormWidget.this._widgetMouseMotionListener);
                    c.addKeyListener(FormWidget.this._widgetKeyListener);
                    return null;
                }
            });
        } else {
            String slotName = widget.getSlot().getName();
            if (FormWidget.equals(slotName, this.getHorizontalStretcher())) {
                this.putClientProperty("horizonal_stretcher", component);
            }
            if (FormWidget.equals(slotName, this.getVerticalStretcher())) {
                this.putClientProperty("vertical_strecher", component);
            }
        }
        this.add(component);
    }

    public void setVerticalStretcher(String vs) {
        this.setLayout(PROPERTY_VERTICAL_STRETCHER, vs);
    }

    public void setWidgetValues() {
    }

    private void translate(Component c, int xShift, int yShift) {
        Point location = c.getLocation();
        location.x += xShift * this._gridSize;
        location.y += yShift * this._gridSize;
        c.setLocation(location);
        this.setModified(true);
    }

    private void updateSize() {
    }

    private void updateWidget(Slot slot) {
        SlotWidget widget = this.getSlotWidget(slot);
        if (widget != null) {
            if (!this.getProject().isSuitableWidget(this.getCls(), slot, null, widget.getDescriptor())) {
                String name = this.getProject().getDefaultWidgetClassName(this.getCls(), slot, null);
                this.replaceWidget((Component)((Object)widget), name);
            } else {
                this.replaceWidget((Component)((Object)widget), widget.getClass().getName());
            }
            this.getProject().postFormChangeEvent(this.getDescriptor());
        }
    }
}

