/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AbstractValidatableComponent;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.widget.FormWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FormWidgetConfigurationLayoutTab
extends AbstractValidatableComponent {
    private static final long serialVersionUID = -722901270560732259L;
    private static final String ALL = "<<all>>";
    private static final String NONE = "<<none>>";
    private FormWidget _formWidget;
    private JComboBox _horizontalStretcherComponent;
    private JComboBox _verticalStretcherComponent;

    public FormWidgetConfigurationLayoutTab(FormWidget widget) {
        this._formWidget = widget;
        this.setLayout(new BorderLayout());
        JPanel grid = new JPanel(new GridLayout(2, 1, 10, 10));
        grid.add(this.createVerticalStretcherComponent());
        grid.add(this.createHorizontalStretcherComponent());
        this.add((Component)grid, "North");
    }

    private JComponent createHorizontalStretcherComponent() {
        this._horizontalStretcherComponent = ComponentFactory.createComboBox();
        this._horizontalStretcherComponent.setRenderer(FrameRenderer.createInstance());
        ArrayList<String> items = new ArrayList<String>(this._formWidget.getCls().getVisibleTemplateSlots());
        items.add(0, ALL);
        items.add(1, NONE);
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(items.toArray());
        this._horizontalStretcherComponent.setModel(model);
        this.setSelection(this._horizontalStretcherComponent, this._formWidget.getHorizontalStretcher(), true);
        return new LabeledComponent("Fill Horizontal Space With:", this._horizontalStretcherComponent);
    }

    private JComponent createVerticalStretcherComponent() {
        this._verticalStretcherComponent = ComponentFactory.createComboBox();
        this._verticalStretcherComponent.setRenderer(FrameRenderer.createInstance());
        ArrayList<String> items = new ArrayList<String>(this._formWidget.getCls().getVisibleTemplateSlots());
        items.add(0, ALL);
        items.add(1, NONE);
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(items.toArray());
        this._verticalStretcherComponent.setModel(model);
        this.setSelection(this._verticalStretcherComponent, this._formWidget.getVerticalStretcher(), false);
        return new LabeledComponent("Fill Vertical Space With:", this._verticalStretcherComponent);
    }

    private String getSelection(JComboBox box) {
        Object o = box.getSelectedItem();
        if (o != null && o != ALL && o != NONE) {
            Slot slot = (Slot)o;
            o = slot.getName();
        }
        return o == null ? null : o.toString();
    }

    public void saveContents() {
        String horiz = this.getSelection(this._horizontalStretcherComponent);
        String vert = this.getSelection(this._verticalStretcherComponent);
        this._formWidget.setHorizontalStretcher(horiz == null ? ALL.toString() : horiz);
        this._formWidget.setVerticalStretcher(vert == null ? NONE.toString() : vert);
    }

    private void setSelection(JComboBox box, String name, boolean defaultValue) {
        Object o = name == null ? (defaultValue ? ALL : NONE) : (name.equals(ALL) ? ALL : (name.equals(NONE) ? NONE : this._formWidget.getKnowledgeBase().getSlot(name)));
        box.setSelectedItem(o);
    }

    public boolean validateContents() {
        return true;
    }
}

