/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.WidgetClassNameRenderer;
import edu.stanford.smi.protege.util.AbstractValidatableComponent;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.widget.FormWidget;
import edu.stanford.smi.protege.widget.WidgetDescriptorEditor;
import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class FormWidgetConfigurationWidgetsTab
extends AbstractValidatableComponent {
    private static final long serialVersionUID = -6726240065845038813L;
    private FormWidget _formWidget;
    private JTable _table;

    public FormWidgetConfigurationWidgetsTab(FormWidget widget) {
        this._formWidget = widget;
        this.setLayout(new BorderLayout());
        this.add(this.createTableComponent());
    }

    private JComponent createTableComponent() {
        this._table = ComponentFactory.createTable(null);
        this._table.setModel(this.createTableModel());
        ComponentUtilities.addColumn(this._table, FrameRenderer.createInstance());
        ComponentUtilities.addColumn(this._table, new WidgetClassNameRenderer(), new WidgetDescriptorEditor(this._formWidget));
        return ComponentFactory.createScrollPane(this._table);
    }

    private TableModel createTableModel() {
        PropertyList propertyList = this._formWidget.getPropertyList();
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn("Slot");
        model.addColumn("Widget");
        ArrayList slots = new ArrayList(this._formWidget.getCls().getVisibleTemplateSlots());
        Collections.sort(slots);
        for (Slot slot : slots) {
            String widgetClassName;
            Rectangle bounds = null;
            WidgetDescriptor d = propertyList.getWidgetDescriptor(slot.getName());
            String string = widgetClassName = d == null ? (String)null : d.getWidgetClassName();
            if (widgetClassName == null) {
                widgetClassName = WidgetClassNameRenderer.NONE;
            } else {
                bounds = d.getBounds();
            }
            model.addRow(new Object[]{slot, widgetClassName, bounds});
        }
        return model;
    }

    public void saveContents() {
        int nRows = this._table.getRowCount();
        TableModel model = this._table.getModel();
        for (int row = 0; row < nRows; ++row) {
            Slot slot = (Slot)model.getValueAt(row, 0);
            String widgetClassName = (String)model.getValueAt(row, 1);
            if (widgetClassName.equals(WidgetClassNameRenderer.NONE)) {
                widgetClassName = null;
            }
            this._formWidget.replaceWidget(slot, widgetClassName);
        }
    }

    public boolean validateContents() {
        return true;
    }
}

