/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.FormDisplay;
import edu.stanford.smi.protege.ui.FormsPanel;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.widget.AbstractTabWidget;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTree;

public class FormsTab
extends AbstractTabWidget {
    private static final long serialVersionUID = -6911540492963136661L;
    private FormsPanel _formsPanel;
    private FormDisplay _formDisplay;

    private JComponent createFormDisplay() {
        this._formDisplay = new FormDisplay(this.getProject());
        return this._formDisplay;
    }

    private JComponent createFormsWidget() {
        this._formsPanel = new FormsPanel(this.getProject());
        this._formsPanel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                FormsTab.this.transmitSelection();
            }
        });
        return this._formsPanel;
    }

    private JComponent createMainSplitter() {
        JSplitPane pane = this.createLeftRightSplitPane("FormsTab.left_right", 250);
        pane.setLeftComponent(this.createFormsWidget());
        pane.setRightComponent(this.createFormDisplay());
        return pane;
    }

    public void initialize() {
        this.setIcon(Icons.getFormIcon());
        this.setLabel(LocalizedText.getText(ResourceKey.FORMS_VIEW_TITLE));
        this.add(this.createMainSplitter());
        this.transmitSelection();
        this.setClsTree(this._formsPanel.getFormsTree());
    }

    public LabeledComponent getLabeledComponent() {
        return this._formsPanel.getLabeledComponent();
    }

    public void setSelectedCls(Cls cls) {
        JTree tree = this._formsPanel.getFormsTree();
        List<Cls> path = ModelUtilities.getPathToRoot(cls);
        ComponentUtilities.setSelectedObjectPath(tree, path);
    }

    private void transmitSelection() {
        Collection selection = this._formsPanel.getSelection();
        if (selection.size() == 1) {
            Cls cls = (Cls)CollectionUtilities.getFirstItem(selection);
            this._formDisplay.setWidgetCls(cls);
        } else {
            this._formDisplay.setWidgetCls(null);
        }
    }

    public static boolean isSuitable(Project project, Collection errors) {
        if (project.isMultiUserClient()) {
            errors.add("Forms don't work in multi-user client mode");
            return false;
        }
        return true;
    }
}

