/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.AbstractValidatableComponent;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protege.widget.Widget;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class GeneralWidgetConfigurationPanel
extends AbstractValidatableComponent {
    private static final long serialVersionUID = -3148523589303750172L;
    private JTextField _labelField;
    private JTextField _tooltipField;
    private SlotWidget _widget;

    public GeneralWidgetConfigurationPanel(SlotWidget widget) {
        this._widget = widget;
        this.setLayout(new GridLayout(0, 1, 10, 10));
        this.add(this.createClsNameField(widget));
        this.add(this.createSlotNameField(widget));
        this.add(this.createLabelNameField(widget));
        this.add(this.createToolTipNameField(widget));
    }

    private JComponent createClsNameField(SlotWidget widget) {
        return this.createFrameField("Class", widget.getCls());
    }

    private JTextField createField(String text) {
        JTextField field = ComponentFactory.createTextField();
        field.setText(text);
        return field;
    }

    private JComponent createFrameField(String label, Instance frame) {
        String text = frame == null ? "" : frame.getName();
        JTextField field = this.createField(text);
        field.setEditable(false);
        return new LabeledComponent(label, field);
    }

    private JComponent createLabelNameField(Widget widget) {
        this._labelField = this.createField(widget.getLabel());
        return new LabeledComponent("Label", this._labelField);
    }

    private JComponent createSlotNameField(SlotWidget widget) {
        return this.createFrameField("Slot", widget.getSlot());
    }

    private JComponent createToolTipNameField(SlotWidget widget) {
        this._tooltipField = this.createField(widget.getDefaultToolTip());
        return new LabeledComponent("Default Tool Tip", this._tooltipField);
    }

    public String getLabel() {
        return this._labelField.getText();
    }

    public void saveContents() {
        this._widget.setLabel(this._labelField.getText());
        this._widget.setDefaultToolTip(this._tooltipField.getText());
    }

    public boolean validateContents() {
        return true;
    }
}

