/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ClsTreeFinder;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.ui.ParentChildRoot;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protege.util.ViewAction;
import java.awt.Component;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;

public class InstanceClsesPanel
extends SelectableContainer {
    private static final long serialVersionUID = -4517364068090464763L;
    private Project _project;
    private SelectableTree _clsTree;
    private LabeledComponent _labeledComponent;

    public InstanceClsesPanel(Project project) {
        this._project = project;
        this.add((Component)this.createHeaderPanel(), "North");
        this._labeledComponent = this.createClsesPanel();
        this.add((Component)this._labeledComponent, "Center");
        this.setSelectable(this._clsTree);
    }

    private JComponent createHeaderPanel() {
        JLabel label = ComponentFactory.createLabel(this._project.getName());
        label.setIcon(Icons.getProjectIcon());
        String classBrowserLabel = LocalizedText.getText(ResourceKey.CLASS_BROWSER_TITLE);
        String forProjectLabel = LocalizedText.getText(ResourceKey.CLASS_BROWSER_FOR_PROJECT_LABEL);
        HeaderComponent header = new HeaderComponent(classBrowserLabel, forProjectLabel, label);
        header.setColor(Colors.getClsColor());
        return header;
    }

    private LabeledComponent createClsesPanel() {
        Cls root = this._project.getKnowledgeBase().getRootCls();
        this._clsTree = ComponentFactory.createSelectableTree(null, new ParentChildRoot(root));
        this._clsTree.setLargeModel(true);
        FrameRenderer renderer = FrameRenderer.createInstance();
        renderer.setDisplayDirectInstanceCount(!this._project.getSuppressInstanceCounting());
        this._clsTree.setCellRenderer(renderer);
        this._clsTree.setSelectionRow(0);
        String classHiearchyLabel = LocalizedText.getText(ResourceKey.CLASS_BROWSER_HIERARCHY_LABEL);
        LabeledComponent c = new LabeledComponent(classHiearchyLabel, ComponentFactory.createScrollPane(this._clsTree));
        c.setBorder(ComponentUtilities.getAlignBorder());
        c.addHeaderButton(this.getViewClsAction());
        c.setFooterComponent(new ClsTreeFinder(this._project.getKnowledgeBase(), this._clsTree));
        return c;
    }

    public JTree getDropComponent() {
        return this._clsTree;
    }

    public LabeledComponent getLabeledComponent() {
        return this._labeledComponent;
    }

    private Action getViewClsAction() {
        return new ViewAction(ResourceKey.CLASS_VIEW, (Selectable)this){
            private static final long serialVersionUID = -94602127828349008L;

            public void onView(Object o) {
                Cls cls = (Cls)o;
                InstanceClsesPanel.this._project.show(cls);
            }
        };
    }

    public void setSelectedCls(Cls cls) {
        List<Cls> path = ModelUtilities.getPathToRoot(cls);
        ComponentUtilities.setSelectedObjectPath(this._clsTree, path);
    }
}

