/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.TreeTarget;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

class InstanceClsesTreeTarget
extends TreeTarget {
    public InstanceClsesTreeTarget() {
        super(false);
    }

    private boolean confirm(JComponent c, Collection instances) {
        boolean result = true;
        if (SystemUtilities.modalDialogInDropWorks()) {
            String text = "Do you want to change the class of ";
            text = instances.size() == 1 ? text + "this instance" : text + "these instances";
            int rval = ModalDialog.showMessageDialog((Component)c, text, 11);
            result = rval == 1;
        }
        return result;
    }

    public boolean doDrop(JTree tree, Object source, int row, Object area) {
        boolean succeeded = false;
        TreePath path = tree.getPathForRow(row);
        Cls targetCls = (Cls)((LazyTreeNode)path.getLastPathComponent()).getUserObject();
        Instance sourceInstance = (Instance)source;
        if (!targetCls.isAbstract()) {
            if (sourceInstance.hasDirectType(targetCls)) {
                Log.getLogger().warning("do nothing on drop");
            } else if (sourceInstance instanceof Cls) {
                if (targetCls.isClsMetaCls()) {
                    sourceInstance.setDirectType(targetCls);
                    succeeded = true;
                }
            } else if (!targetCls.isClsMetaCls()) {
                sourceInstance.setDirectType(targetCls);
                succeeded = true;
            }
        }
        return succeeded;
    }

    public boolean doDrop(JTree tree, Collection sources, int row, Object area) {
        boolean succeeded = false;
        if (this.confirm(tree, sources)) {
            succeeded = super.doDrop(tree, sources, row, area);
        }
        return succeeded;
    }
}

