/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.action.DeleteInstancesAction;
import edu.stanford.smi.protege.action.ReferencersAction;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.ReadOnlyWidgetConfigurationPanel;
import edu.stanford.smi.protege.widget.WidgetConfigurationPanel;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JList;

public class InstanceFieldWidget
extends AbstractSlotWidget {
    private static final long serialVersionUID = 376700956825053322L;
    private JList _list;
    private Instance _instance;
    private AllowableAction _createAction;
    private AllowableAction _addAction;
    private AllowableAction _removeAction;
    private AllowableAction _deleteAction;
    private boolean _showNewInstances = true;
    private FrameListener _instanceListener = new FrameAdapter(){

        public void browserTextChanged(FrameEvent event) {
            InstanceFieldWidget.this._list.repaint();
        }
    };

    protected void addButton(LabeledComponent c, Action action, boolean defaultState) {
        if (action != null) {
            this.addButtonConfiguration(action, defaultState);
            if (this.displayButton(action)) {
                c.addHeaderButton(action);
            }
        }
    }

    protected void addButtons(LabeledComponent c) {
        this.addButton(c, this.getViewInstanceAction(), true);
        this.addButton(c, new ReferencersAction(this), false);
        this.addButton(c, this.getCreateInstanceAction(), true);
        this.addButton(c, this.getSelectInstanceAction(), true);
        this.addButton(c, this.getRemoveInstanceAction(), true);
        this.addButton(c, this.getDeleteInstancesAction(), false);
    }

    public JList createList() {
        SelectableList list = ComponentFactory.createSingleItemList(this.getDoubleClickAction());
        list.setCellRenderer(FrameRenderer.createInstance());
        return list;
    }

    public void dispose() {
        if (this._instance != null) {
            this._instance.removeFrameListener(this._instanceListener);
        }
        super.dispose();
    }

    protected Action getCreateInstanceAction() {
        this._createAction = new CreateAction(ResourceKey.INSTANCE_CREATE){
            private static final long serialVersionUID = 1867649088443463104L;

            public void onCreate() {
                InstanceFieldWidget.this.handleCreateAction();
            }
        };
        return this._createAction;
    }

    protected Action getDeleteInstancesAction() {
        this._deleteAction = new DeleteInstancesAction(this);
        return this._deleteAction;
    }

    protected Action getRemoveInstanceAction() {
        this._removeAction = new RemoveAction(ResourceKey.INSTANCE_REMOVE, (Selectable)this){
            private static final long serialVersionUID = 2629621785174837136L;

            public void onRemove(Object o) {
                InstanceFieldWidget.this.handleRemoveAction();
            }
        };
        return this._removeAction;
    }

    protected Action getSelectInstanceAction() {
        this._addAction = new AddAction(ResourceKey.INSTANCE_ADD){
            private static final long serialVersionUID = -5463810763929014137L;

            public void onAdd() {
                InstanceFieldWidget.this.handleAddAction();
            }
        };
        return this._addAction;
    }

    public Collection getSelection() {
        return CollectionUtilities.createCollection(this._instance);
    }

    public Collection getValues() {
        return CollectionUtilities.createList(this._instance);
    }

    protected Action getViewInstanceAction() {
        return new ViewAction(ResourceKey.INSTANCE_VIEW, (Selectable)this){
            private static final long serialVersionUID = 7309253827733187916L;

            public void onView(Object o) {
                InstanceFieldWidget.this.handleViewAction((Instance)o);
            }
        };
    }

    protected void handleAddAction() {
        Collection clses = this.getCls().getTemplateSlotAllowedClses(this.getSlot());
        Instance instance = DisplayUtilities.pickInstance((Component)this, clses);
        if (instance != null) {
            this.setDisplayedInstance(instance);
        }
    }

    protected void handleCreateAction() {
        Collection clses = this.getCls().getTemplateSlotAllowedClses(this.getSlot());
        Cls cls = DisplayUtilities.pickConcreteCls((Component)this, this.getKnowledgeBase(), clses);
        if (cls != null) {
            Cls newcls;
            Instance instance = this.getKnowledgeBase().createInstance(null, cls);
            if (instance instanceof Cls && (newcls = (Cls)instance).getDirectSuperclassCount() == 0) {
                newcls.addDirectSuperclass(this.getKnowledgeBase().getRootCls());
            }
            if (this._showNewInstances) {
                this.showInstance(instance);
            }
            this.setDisplayedInstance(instance);
        }
    }

    protected void handleRemoveAction() {
        this.removeDisplayedInstance();
    }

    protected void handleViewAction(Instance instance) {
        this.showInstance(instance);
    }

    public void initialize() {
        this._list = this.createList();
        LabeledComponent c = new LabeledComponent(this.getLabel(), this._list);
        this.addButtons(c);
        this.add(c);
        this.setPreferredColumns(2);
        this.setPreferredRows(1);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean isSuitable;
        if (cls == null || slot == null) {
            isSuitable = false;
        } else {
            boolean isInstance = cls.getTemplateSlotValueType(slot) == ValueType.INSTANCE;
            boolean isMultiple = cls.getTemplateSlotAllowsMultipleValues(slot);
            isSuitable = isInstance && !isMultiple;
        }
        return isSuitable;
    }

    protected void removeDisplayedInstance() {
        this.replaceInstance(null);
        this.updateList();
        this.valueChanged();
    }

    protected void replaceInstance(Instance instance) {
        if (this._instance != null) {
            this._instance.removeFrameListener(this._instanceListener);
        }
        this._instance = instance;
        if (this._instance != null) {
            this._instance.addFrameListener(this._instanceListener);
        }
        this.notifySelectionListeners();
    }

    protected void setDisplayedInstance(Instance instance) {
        this.replaceInstance(instance);
        this.updateList();
        this.valueChanged();
    }

    public void setEditable(boolean b) {
        b = b && !this.isReadOnlyConfiguredWidget();
        InstanceFieldWidget.setAllowed(this._createAction, b);
        InstanceFieldWidget.setAllowed(this._addAction, b);
        InstanceFieldWidget.setAllowed(this._removeAction, b);
        InstanceFieldWidget.setAllowed(this._deleteAction, b);
    }

    public void setValues(Collection values) {
        Instance value = (Instance)CollectionUtilities.getFirstItem(values);
        this.replaceInstance(value);
        this.updateList();
    }

    protected void updateList() {
        ComponentUtilities.setListValues(this._list, CollectionUtilities.createCollection(this._instance));
    }

    public boolean getShowNewInstances() {
        return this._showNewInstances;
    }

    public void setShowNewInstances(boolean b) {
        this._showNewInstances = b;
    }

    public WidgetConfigurationPanel createWidgetConfigurationPanel() {
        WidgetConfigurationPanel confPanel = super.createWidgetConfigurationPanel();
        confPanel.addTab("Options", new ReadOnlyWidgetConfigurationPanel(this));
        return confPanel;
    }
}

