/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.action.DeleteInstancesAction;
import edu.stanford.smi.protege.action.ReferencersAction;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractListWidget;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Action;

public class InstanceListWidget
extends AbstractListWidget {
    private static final long serialVersionUID = -3207320406959420859L;
    private AllowableAction _createInstanceAction;
    private AllowableAction _addInstancesAction;
    private AllowableAction _removeInstancesAction;
    private AllowableAction _deleteInstancesAction;
    private AllowableAction _viewInstanceAction;
    private boolean _showNewInstances = true;
    private FrameListener _instanceListener = new FrameAdapter(){

        public void browserTextChanged(FrameEvent event) {
            super.browserTextChanged(event);
            InstanceListWidget.this.repaint();
        }
    };

    protected void addButtons(LabeledComponent c) {
        this.addButton(this.getViewInstanceAction());
        this.addButton(this.getCreateInstanceAction());
        this.addButton(new ReferencersAction(this), false);
        this.addButton(this.getAddInstancesAction());
        this.addButton(this.getRemoveInstancesAction());
        this.addButton(this.getDeleteInstancesAction(), false);
    }

    public void addItem(Object item) {
        super.addItem(item);
        this.addListener(CollectionUtilities.createCollection(item));
    }

    public void addItems(Collection items) {
        super.addItems(items);
        this.addListener(items);
    }

    protected void addListener(Collection values) {
        for (Instance instance : values) {
            instance.addFrameListener(this._instanceListener);
        }
    }

    public void dispose() {
        this.removeListener(this.getValues());
        super.dispose();
    }

    protected Action getAddInstancesAction() {
        this._addInstancesAction = new AddAction(ResourceKey.INSTANCE_ADD){
            private static final long serialVersionUID = -5397657826029556524L;

            public void onAdd() {
                InstanceListWidget.this.handleAddAction();
            }
        };
        return this._addInstancesAction;
    }

    public Action getCreateInstanceAction() {
        this._createInstanceAction = new CreateAction(ResourceKey.INSTANCE_CREATE){
            private static final long serialVersionUID = -511147408901936946L;

            public void onCreate() {
                InstanceListWidget.this.handleCreateAction();
            }
        };
        return this._createInstanceAction;
    }

    protected Action getDeleteInstancesAction() {
        this._deleteInstancesAction = new DeleteInstancesAction(this);
        return this._deleteInstancesAction;
    }

    protected Action getRemoveInstancesAction() {
        this._removeInstancesAction = new RemoveAction(ResourceKey.INSTANCE_REMOVE, (Selectable)this){
            private static final long serialVersionUID = 2415308209387049694L;

            public void onRemove(Collection instances) {
                InstanceListWidget.this.handleRemoveAction(instances);
            }
        };
        return this._removeInstancesAction;
    }

    protected Action getViewInstanceAction() {
        this._viewInstanceAction = new ViewAction(ResourceKey.INSTANCE_VIEW, (Selectable)this){
            private static final long serialVersionUID = 1848862060962178950L;

            public void onView(Object o) {
                InstanceListWidget.this.handleViewAction((Instance)o);
            }
        };
        return this._viewInstanceAction;
    }

    protected void handleAddAction() {
        Collection clses = this.getCls().getTemplateSlotAllowedClses(this.getSlot());
        String title = (String)this._addInstancesAction.getValue("Name");
        this.addItems(DisplayUtilities.pickInstances((Component)this, clses, title));
    }

    protected void handleCreateAction() {
        Collection clses = this.getCls().getTemplateSlotAllowedClses(this.getSlot());
        Cls cls = DisplayUtilities.pickConcreteCls((Component)this, this.getKnowledgeBase(), clses);
        if (cls != null) {
            Cls newcls;
            Instance instance = this.getKnowledgeBase().createInstance(null, cls);
            if (instance instanceof Cls && (newcls = (Cls)instance).getDirectSuperclassCount() == 0) {
                newcls.addDirectSuperclass(this.getKnowledgeBase().getRootCls());
            }
            if (this._showNewInstances) {
                this.showInstance(instance);
            }
            this.addItem(instance);
        }
    }

    protected void handleRemoveAction(Collection instances) {
        this.removeItems(instances);
    }

    protected void handleViewAction(Instance instance) {
        this.showInstance(instance);
    }

    public void initialize() {
        super.initialize();
        this.addButtons(this.getLabeledComponent());
        this.setRenderer(FrameRenderer.createInstance());
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean isSuitable;
        if (cls == null || slot == null) {
            isSuitable = false;
        } else {
            boolean isInstance = InstanceListWidget.equals(cls.getTemplateSlotValueType(slot), ValueType.INSTANCE);
            boolean isMultiple = cls.getTemplateSlotAllowsMultipleValues(slot);
            isSuitable = isInstance && isMultiple;
        }
        return isSuitable;
    }

    protected void removeListener(Collection values) {
        for (Instance instance : values) {
            instance.removeFrameListener(this._instanceListener);
        }
    }

    public void setEditable(boolean b) {
        b = b && !this.isReadOnlyConfiguredWidget();
        InstanceListWidget.setAllowed(this._createInstanceAction, b);
        InstanceListWidget.setAllowed(this._addInstancesAction, b);
        InstanceListWidget.setAllowed(this._removeInstancesAction, b);
        InstanceListWidget.setAllowed(this._deleteInstancesAction, b);
    }

    public void setValues(Collection values) {
        this.removeListener(this.getValues());
        this.addListener(values);
        super.setValues(values);
    }

    public boolean getShowNewInstances() {
        return this._showNewInstances;
    }

    public void setShowNewInstances(boolean b) {
        this._showNewInstances = b;
    }
}

