/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.widget.TextFieldWidget;
import java.util.Collection;

public class InstanceNameWidget
extends TextFieldWidget {
    private static final long serialVersionUID = -1873474195346387238L;

    public void addNotify() {
        super.addNotify();
        if (this.isRuntime() && this.needsNameChange()) {
            this.selectAll();
        }
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return slot.getName().equals(":NAME");
    }

    private boolean needsNameChange() {
        if (this.getInstance() == null) {
            return false;
        }
        boolean needsNameChange = false;
        String name = this.getInstance().getName();
        if (this.isEditable() && name != null) {
            int index = name.lastIndexOf(95);
            String possibleIntegerString = name.substring(index + 1);
            try {
                Integer.parseInt(possibleIntegerString);
                needsNameChange = true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return needsNameChange;
    }

    public void setAssociatedCls(Cls associatedCls) {
        super.setAssociatedCls(associatedCls);
        if (associatedCls != null) {
            this.setEditable(false);
        }
    }

    public void setEditable(boolean b) {
        super.setEditable(b && !this.isSlotAtCls());
    }

    public void setInstance(Instance instance) {
        super.setInstance(instance);
        if (this.needsNameChange()) {
            this.selectAll();
        }
    }

    public void setInstanceValues() {
        Collection values = this.getValues();
        if (values == null) {
            throw new IllegalArgumentException("Illegal null value for frame");
        }
        if (values.isEmpty()) {
            throw new IllegalArgumentException("Missing name for class");
        }
        if (values.size() > 1) {
            throw new IllegalArgumentException("Too many names for frame " + values.size());
        }
        if (!(values.iterator().next() instanceof String)) {
            throw new IllegalArgumentException("name should be a string");
        }
        String name = (String)values.iterator().next();
        Instance i = this.getInstance();
        if (i.getName().equals(name)) {
            return;
        }
        i.rename(name);
        this.markDirty(false);
    }

    protected String getInvalidTextDescription(String text) {
        String invalidText = null;
        if (text == null || !this.isValidName(text)) {
            invalidText = "Invalid frame name";
        }
        return invalidText;
    }

    private boolean isValidName(String name) {
        Instance currentFrame = this.getInstance();
        Frame frame = this.getKnowledgeBase().getFrame(name);
        boolean isDuplicate = frame != null && !frame.equals(currentFrame);
        boolean isValid = this.getKnowledgeBase().isValidFrameName(name, currentFrame);
        return isValid && !isDuplicate && name.length() > 0;
    }

    public void setWidgetValues() {
        if (this.isSlotAtCls()) {
            this.setText(this.getInstance().getName());
        } else {
            super.setWidgetValues();
        }
    }

    public String getLabel() {
        return this.localizeStandardLabel(super.getLabel(), "Name", ResourceKey.NAME_SLOT_WIDGET_LABEL);
    }
}

