/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.ValueTypeConstraint;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ListSelectionListenerAdapter;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractValuesComponent;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JScrollPane;

public class InstanceValuesComponent
extends AbstractValuesComponent
implements Selectable {
    private static final long serialVersionUID = 4953040207043705676L;
    private Project _project;
    private SelectableList _list;
    private AllowableAction _addAction;
    private AllowableAction _removeAction;

    public InstanceValuesComponent(Project project) {
        this._project = project;
        this._list = ComponentFactory.createSelectableList(null, true);
        this._list.setCellRenderer(FrameRenderer.createInstance());
        this._list.addListSelectionListener(new ListSelectionListenerAdapter(this));
        String text = LocalizedText.getText(ResourceKey.ALLOWED_CLASSES);
        LabeledComponent c = new LabeledComponent(text, new JScrollPane(this._list));
        c.addHeaderButton(this.getViewAction());
        c.addHeaderButton(this.getAddClsesAction());
        c.addHeaderButton(this.getRemoveClsesAction());
        this.add(c);
    }

    protected void addUniqueListValues(Collection clses) {
        ComponentUtilities.addUniqueListValues(this._list, clses);
        this.valueChanged();
    }

    public void clearSelection() {
        this._list.clearSelection();
    }

    private Action getAddClsesAction() {
        this._addAction = new AddAction(ResourceKey.CLASS_ADD){
            private static final long serialVersionUID = -5345344713282197201L;

            public void onAdd() {
                Collection clses = DisplayUtilities.pickClses((Component)InstanceValuesComponent.this._list, InstanceValuesComponent.this.getKnowledgeBase(), InstanceValuesComponent.this.getBaseClses());
                InstanceValuesComponent.this.addUniqueListValues(clses);
            }
        };
        return this._addAction;
    }

    private Collection getBaseClses() {
        Collection baseClses;
        if (this.isOverride()) {
            baseClses = this.getInheritedAllowedClses();
            if (baseClses.isEmpty()) {
                baseClses = this.getKnowledgeBase().getRootClses();
            }
        } else {
            baseClses = this.getKnowledgeBase().getRootClses();
        }
        return baseClses;
    }

    private Collection getInheritedAllowedClses() {
        HashSet allowedClses = new HashSet();
        for (Cls superclass : this.getAssociatedCls().getDirectSuperclasses()) {
            allowedClses.addAll(superclass.getTemplateSlotAllowedClses(this.getSlotInstance()));
        }
        return allowedClses;
    }

    protected Project getProject() {
        return this._project;
    }

    private Action getRemoveClsesAction() {
        this._removeAction = new RemoveAction(ResourceKey.CLASS_REMOVE, (Selectable)this){
            private static final long serialVersionUID = 4200700343932259499L;

            public void onRemove(Collection clses) {
                ComponentUtilities.removeListValues(InstanceValuesComponent.this._list, clses);
                InstanceValuesComponent.this.valueChanged();
            }
        };
        return this._removeAction;
    }

    public Collection getSelection() {
        return this._list.getSelection();
    }

    public Collection getValues() {
        Collection clses = ComponentUtilities.getListValues(this._list);
        return ValueTypeConstraint.getValues(ValueType.INSTANCE, clses);
    }

    private Action getViewAction() {
        return new ViewAction(ResourceKey.CLASS_VIEW, (Selectable)this){
            private static final long serialVersionUID = -5159948547425769907L;

            public void onView(Object o) {
                Cls cls = (Cls)o;
                InstanceValuesComponent.this._project.show(cls);
            }
        };
    }

    public void setEditable(boolean b) {
        this._addAction.setAllowed(b);
        this._removeAction.setAllowed(b);
    }

    protected void setSelection(Cls cls) {
        this._list.setSelectedValue(cls, true);
    }

    public void setValues(Collection values) {
        Collection clses = ValueTypeConstraint.getAllowedClses(values);
        ComponentUtilities.setListValues(this._list, clses);
    }
}

