/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.widget.NumberFieldWidget;
import java.util.ArrayList;
import java.util.Collection;

public class IntegerFieldWidget
extends NumberFieldWidget {
    private static final long serialVersionUID = 6750189081136351439L;

    protected String getInvalidTextDescription(String text) {
        String result = null;
        try {
            Number max;
            int i = new Integer(text);
            Number min = this.getCls().getTemplateSlotMinimumValue(this.getSlot());
            if (min != null && i < min.intValue()) {
                result = "The minimum value is " + min;
            }
            if ((max = this.getCls().getTemplateSlotMaximumValue(this.getSlot())) != null && i > max.intValue()) {
                result = "The maximum value is " + max;
            }
        }
        catch (NumberFormatException e) {
            result = "The value must be a number";
        }
        return result;
    }

    public Collection getValues() {
        ArrayList<Integer> values = new ArrayList<Integer>();
        String text = this.getText();
        try {
            if (text != null) {
                values.add(new Integer(text));
            }
        }
        catch (NumberFormatException e) {
            this.setText(null);
        }
        return values;
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean result = false;
        if (cls != null && slot != null) {
            boolean isInteger = IntegerFieldWidget.equals(cls.getTemplateSlotValueType(slot), ValueType.INTEGER);
            boolean isMultiple = cls.getTemplateSlotAllowsMultipleValues(slot);
            result = isInteger && !isMultiple;
        }
        return result;
    }
}

