/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.IntegerValidator;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractListWidget;
import java.util.Collection;
import javax.swing.Action;

public class IntegerListWidget
extends AbstractListWidget {
    private static final long serialVersionUID = 2981954085470364325L;

    private Action getCreateAction() {
        return new CreateAction(ResourceKey.VALUE_ADD){
            private static final long serialVersionUID = 7897593852333790200L;

            public void onCreate() {
                IntegerListWidget.this.handleCreateAction();
            }
        };
    }

    private Action getDeleteAction() {
        return new RemoveAction(ResourceKey.VALUE_REMOVE, (Selectable)this){
            private static final long serialVersionUID = -8788770985599278160L;

            public void onRemove(Collection integers) {
                IntegerListWidget.this.handleRemoveAction(integers);
            }
        };
    }

    private Action getEditAction() {
        return new ViewAction(ResourceKey.VALUE_VIEW, (Selectable)this){
            private static final long serialVersionUID = 1756407039881297844L;

            public void onView(Object o) {
                IntegerListWidget.this.handleViewAction((Integer)o);
            }
        };
    }

    protected void handleCreateAction() {
        String s = DisplayUtilities.editString(this, "Create Integer Value", null, new IntegerValidator());
        if (s != null) {
            this.addItem(new Integer(s));
        }
    }

    protected void handleRemoveAction(Collection integers) {
        this.removeItems(integers);
    }

    protected void handleViewAction(Integer integer) {
        String s = DisplayUtilities.editString(this, "Edit Integer Value", integer.toString(), null);
        if (s != null) {
            this.replaceItem(integer, new Integer(s));
        }
    }

    public void initialize() {
        Action editAction = this.getEditAction();
        super.initialize(editAction);
        this.addButton(editAction);
        this.addButton(this.getCreateAction());
        this.addButton(this.getDeleteAction());
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean isSuitable;
        if (cls == null || slot == null) {
            isSuitable = false;
        } else {
            boolean isInteger = IntegerListWidget.equals(cls.getTemplateSlotValueType(slot), ValueType.INTEGER);
            boolean isMultiple = cls.getTemplateSlotAllowsMultipleValues(slot);
            isSuitable = isInteger && isMultiple;
        }
        return isSuitable;
    }
}

