/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.Action;
import javax.swing.JList;

public class InverseSlotWidget
extends AbstractSlotWidget {
    private static final long serialVersionUID = 2385835722545274787L;
    private JList _list;
    private AllowableAction _viewAction;
    private AllowableAction _createAction;
    private AllowableAction _addAction;
    private AllowableAction _removeAction;
    private FrameListener _frameListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent event) {
            InverseSlotWidget.this.updateWidget();
        }
    };

    private Slot createInverseSlot() {
        Slot inverseSlot = null;
        try {
            Slot forwardSlot = (Slot)this.getInstance();
            this.beginTransaction("create inverse slot for " + forwardSlot.getName(), forwardSlot == null ? null : "inverse_of_" + forwardSlot.getName());
            String slotName = "inverse_of_" + forwardSlot.getName();
            while (this.getKnowledgeBase().getFrame(slotName) != null) {
                slotName = slotName + "_";
            }
            Collection inverseSuperslots = this.getSuperslotInverses(forwardSlot);
            Cls metaSlot = this.getKnowledgeBase().getDefaultSlotMetaCls();
            inverseSlot = this.getKnowledgeBase().createSlot(slotName, metaSlot, inverseSuperslots, true);
            Collection range = forwardSlot.getAllowedClses();
            Collection domain = forwardSlot.getDirectDomain();
            inverseSlot.setAllowedClses(domain);
            this.setDomain(inverseSlot, range);
            inverseSlot.setAllowsMultipleValues(true);
            this.setInverseSlot(inverseSlot);
            this.commitTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction();
            Log.getLogger().warning("Could not create inverse slot for: " + this.getInstance());
        }
        return inverseSlot;
    }

    private void setDomain(Slot slot, Collection domain) {
        for (Cls cls : domain) {
            cls.addDirectTemplateSlot(slot);
        }
    }

    private Collection getSuperslotInverses(Slot forwardSlot) {
        LinkedHashSet<Slot> superslotInverses = new LinkedHashSet<Slot>();
        for (Slot superslot : forwardSlot.getSuperslots()) {
            Slot superslotInverse = superslot.getInverseSlot();
            if (superslotInverse == null) continue;
            superslotInverses.add(superslotInverse);
        }
        return superslotInverses;
    }

    private JList createList() {
        SelectableList list = ComponentFactory.createSingleItemList(this.getViewAction());
        list.setCellRenderer(FrameRenderer.createInstance());
        return list;
    }

    private Action getAddAction() {
        if (this._addAction == null) {
            this._addAction = new AddAction(ResourceKey.SLOT_ADD){
                private static final long serialVersionUID = -1866653350636802271L;

                public void onAdd() {
                    InverseSlotWidget.this.selectSlotToAdd();
                }
            };
        }
        return this._addAction;
    }

    private Action getCreateAction() {
        if (this._createAction == null) {
            this._createAction = new CreateAction(ResourceKey.SLOT_CREATE){
                private static final long serialVersionUID = 8559254382775291576L;

                public void onCreate() {
                    Slot slot = InverseSlotWidget.this.createInverseSlot();
                    InverseSlotWidget.this.getProject().show(slot);
                }
            };
        }
        return this._createAction;
    }

    protected Collection getPossibleInverses() {
        ArrayList<Slot> possibleInverses = new ArrayList<Slot>();
        for (Slot slot : this.getKnowledgeBase().getSlots()) {
            ValueType type = slot.getValueType();
            Slot inverseSlot = slot.getInverseSlot();
            if (slot.isSystem() || !InverseSlotWidget.equals(type, ValueType.INSTANCE) || inverseSlot != null) continue;
            possibleInverses.add(slot);
        }
        return possibleInverses;
    }

    private Action getRemoveAction() {
        if (this._removeAction == null) {
            this._removeAction = new RemoveAction(ResourceKey.SLOT_REMOVE, (Selectable)this){
                private static final long serialVersionUID = -4572085279905671010L;

                public void onRemove(Object o) {
                    InverseSlotWidget.this.setInverseSlot(null);
                }
            };
        }
        return this._removeAction;
    }

    public Collection getSelection() {
        return this.getValues();
    }

    public Collection getValues() {
        return ComponentUtilities.getListValues(this._list);
    }

    private Action getViewAction() {
        if (this._viewAction == null) {
            this._viewAction = new ViewAction(ResourceKey.SLOT_VIEW, (Selectable)this){
                private static final long serialVersionUID = 1522315576409668965L;

                public void onView(Object o) {
                    Slot slot = (Slot)o;
                    InverseSlotWidget.this.getProject().show(slot);
                }
            };
        }
        return this._viewAction;
    }

    public void initialize() {
        this._list = this.createList();
        LabeledComponent c = new LabeledComponent(this.getLabel(), this._list);
        c.addHeaderButton(this.getViewAction());
        c.addHeaderButton(this.getCreateAction());
        c.addHeaderButton(this.getAddAction());
        c.addHeaderButton(this.getRemoveAction());
        if (this.isSlotAtCls()) {
            this._createAction.setAllowed(false);
            this._addAction.setAllowed(false);
            this._removeAction.setAllowed(false);
        }
        this.add(c);
        this.setPreferredColumns(2);
        this.setPreferredRows(1);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return slot.getName().equals(":SLOT-INVERSE");
    }

    private void selectSlotToAdd() {
        Collection possibleInverses = this.getPossibleInverses();
        if (possibleInverses.isEmpty()) {
            String text = "There are no existing slots which can be used as an inverse.";
            ModalDialog.showMessageDialog(this, text);
        } else {
            Slot slot = DisplayUtilities.pickSlot(this, possibleInverses);
            if (slot != null) {
                this.setInverseSlot(slot);
            }
        }
    }

    public void setEditable(boolean b) {
        this.updateWidget();
    }

    public void setInstance(Instance newInstance) {
        Instance oldInstance = this.getInstance();
        if (oldInstance != null && !this.isSlotAtCls()) {
            oldInstance.removeFrameListener(this._frameListener);
        }
        super.setInstance(newInstance);
        if (newInstance != null && !this.isSlotAtCls()) {
            newInstance.addFrameListener(this._frameListener);
        }
    }

    private void setInverseSlot(Slot slot) {
        Collection<Slot> values = CollectionUtilities.createCollection(slot);
        ComponentUtilities.setListValues(this._list, values);
        this.valueChanged();
    }

    public void setValues(Collection c) {
        ComponentUtilities.setListValues(this._list, c);
    }

    private void updateWidget() {
        boolean editable;
        Instance instance = this.getInstance();
        boolean bl = editable = !this.isSlotAtCls() && instance.isEditable();
        if (editable && instance instanceof Slot) {
            ValueType type = ((Slot)instance).getValueType();
            editable = InverseSlotWidget.equals(type, ValueType.INSTANCE) || InverseSlotWidget.equals(type, ValueType.CLS);
        }
        this._createAction.setAllowed(editable);
        this._addAction.setAllowed(editable);
        this._removeAction.setAllowed(editable);
    }

    public String getLabel() {
        return this.localizeStandardLabel(super.getLabel(), "Inverse Slot", ResourceKey.INVERSE_SLOT_WIDGET_LABEL);
    }
}

