/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.widget.AbstractTabWidget;
import edu.stanford.smi.protege.widget.KAToolTabConfigurationPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class KAToolTab
extends AbstractTabWidget {
    private static final long serialVersionUID = -9019526061083858552L;
    private static final String TOP_LEVEL_INSTANCE_PROPERTY = "KATool.TOP_LEVEL_INSTANCE";

    public boolean configure() {
        KAToolTabConfigurationPanel panel = new KAToolTabConfigurationPanel(this);
        ModalDialog.showDialog(this, panel, "Configure KA Tool", 11);
        return true;
    }

    private JComponent createClsPanel() {
        Instance topLevelInstance = this.getTopLevelInstance();
        Assert.assertNotNull("top level instance", topLevelInstance);
        InstanceDisplay d = new InstanceDisplay(this.getProject());
        d.setInstance(topLevelInstance);
        return d;
    }

    private Action createSelectClsAction() {
        return new AbstractAction("Press to select top-level instance"){
            private static final long serialVersionUID = -6735287155779212076L;

            public void actionPerformed(ActionEvent event) {
                Instance instance = DisplayUtilities.pickInstance((Component)KAToolTab.this, KAToolTab.this.getKnowledgeBase());
                if (instance != null) {
                    KAToolTab.this.setTopLevelInstance(instance);
                }
            }
        };
    }

    private JComponent createSetupPanel() {
        JPanel outerPanel = new JPanel(new FlowLayout());
        JPanel innerPanel = new JPanel(new BorderLayout());
        innerPanel.add(ComponentFactory.createButton(this.createSelectClsAction()));
        outerPanel.add(innerPanel);
        return outerPanel;
    }

    public Instance getTopLevelInstance() {
        Instance result = null;
        String name = this.getPropertyList().getString(TOP_LEVEL_INSTANCE_PROPERTY);
        if (name != null && (result = this.getKnowledgeBase().getInstance(name)) == null) {
            Log.getLogger().warning("Unable to find top level instance " + name);
        }
        return result;
    }

    public void initialize() {
        if (this.getLabel() == null) {
            this.setLabel("Knowledge Acquisition");
        }
        this.setupUI();
    }

    public void setTopLevelInstance(Instance instance) {
        this.getPropertyList().setString(TOP_LEVEL_INSTANCE_PROPERTY, instance.getName());
        this.setupUI();
    }

    private void setupUI() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        Instance topLevelInstance = this.getTopLevelInstance();
        JComponent mainForm = topLevelInstance == null ? this.createSetupPanel() : this.createClsPanel();
        this.add(mainForm);
        this.revalidate();
        this.repaint();
    }
}

