/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.IntegerField;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MaximumCardinalityWidget
extends AbstractSlotWidget {
    private static final long serialVersionUID = 1980239748634279491L;
    private JCheckBox _isMultipleComponent;
    private IntegerField _atMostComponent;
    private ActionListener _buttonListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            MaximumCardinalityWidget.this._atMostComponent.removeActionListener(MaximumCardinalityWidget.this._textFieldListener);
            if (MaximumCardinalityWidget.this._isMultipleComponent.isSelected()) {
                MaximumCardinalityWidget.this._atMostComponent.clearValue();
            } else {
                MaximumCardinalityWidget.this._atMostComponent.setValue(1);
            }
            MaximumCardinalityWidget.this._atMostComponent.addActionListener(MaximumCardinalityWidget.this._textFieldListener);
            MaximumCardinalityWidget.this.valueChanged();
        }
    };
    private ActionListener _textFieldListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            Integer i = MaximumCardinalityWidget.this._atMostComponent.getValue();
            boolean multiple = i != null && i > 1;
            MaximumCardinalityWidget.this._isMultipleComponent.removeActionListener(MaximumCardinalityWidget.this._buttonListener);
            MaximumCardinalityWidget.this._isMultipleComponent.setSelected(multiple);
            MaximumCardinalityWidget.this._isMultipleComponent.addActionListener(MaximumCardinalityWidget.this._buttonListener);
            MaximumCardinalityWidget.this.valueChanged();
        }
    };

    private Component createAtMostComponent() {
        String label = LocalizedText.getText(ResourceKey.AT_MOST_LABEL);
        this._atMostComponent = new IntegerField(label);
        this._atMostComponent.addActionListener(this._textFieldListener);
        JPanel c = new JPanel(new FlowLayout(2, 0, 0));
        c.add(this._atMostComponent);
        return c;
    }

    private JComponent createIsMultipleComponent() {
        String label = LocalizedText.getText(ResourceKey.MULTIPLE_LABEL);
        this._isMultipleComponent = ComponentFactory.createCheckBox(label);
        this._isMultipleComponent.addActionListener(this._buttonListener);
        return this._isMultipleComponent;
    }

    public Collection getValues() {
        Integer max = this._atMostComponent.getValue();
        return CollectionUtilities.createCollection(max);
    }

    public void initialize() {
        JPanel panel = new JPanel(new GridLayout(1, 2));
        panel.add(this.createIsMultipleComponent());
        panel.add(this.createAtMostComponent());
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)panel, "North");
        this.add(p);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return slot.getName().equals(":SLOT-MAXIMUM-CARDINALITY");
    }

    public void setEditable(boolean editable) {
        this._isMultipleComponent.setEnabled(editable);
        this._atMostComponent.setEnabled(editable);
    }

    public void setValues(Collection values) {
        Integer i = (Integer)MaximumCardinalityWidget.getFirstItem(values);
        boolean isMultiple = i == null || i > 1;
        this._isMultipleComponent.removeActionListener(this._buttonListener);
        this._atMostComponent.removeActionListener(this._textFieldListener);
        this._isMultipleComponent.setSelected(isMultiple);
        if (i == null) {
            this._atMostComponent.clearValue();
        } else {
            this._atMostComponent.setValue(i);
        }
        this._isMultipleComponent.addActionListener(this._buttonListener);
        this._atMostComponent.addActionListener(this._textFieldListener);
    }
}

