/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.IntegerField;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MinimumCardinalityWidget
extends AbstractSlotWidget {
    private static final long serialVersionUID = -28100150611436999L;
    private JCheckBox _isRequiredComponent;
    private IntegerField _atLeastComponent;
    private ActionListener _buttonListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            MinimumCardinalityWidget.this._atLeastComponent.removeActionListener(MinimumCardinalityWidget.this._textFieldListener);
            if (MinimumCardinalityWidget.this._isRequiredComponent.isSelected()) {
                MinimumCardinalityWidget.this._atLeastComponent.setValue(1);
            } else {
                MinimumCardinalityWidget.this._atLeastComponent.clearValue();
            }
            MinimumCardinalityWidget.this._atLeastComponent.addActionListener(MinimumCardinalityWidget.this._textFieldListener);
            MinimumCardinalityWidget.this.valueChanged();
        }
    };
    private ActionListener _textFieldListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            Integer i = MinimumCardinalityWidget.this._atLeastComponent.getValue();
            boolean optional = i == null || i == 0;
            MinimumCardinalityWidget.this._isRequiredComponent.removeActionListener(MinimumCardinalityWidget.this._buttonListener);
            MinimumCardinalityWidget.this._isRequiredComponent.setSelected(!optional);
            MinimumCardinalityWidget.this._isRequiredComponent.addActionListener(MinimumCardinalityWidget.this._buttonListener);
            MinimumCardinalityWidget.this.valueChanged();
        }
    };

    private Component createAtLeastComponent() {
        String label = LocalizedText.getText(ResourceKey.AT_LEAST_LABEL);
        this._atLeastComponent = new IntegerField(label);
        this._atLeastComponent.addActionListener(this._textFieldListener);
        JPanel c = new JPanel(new FlowLayout(2, 0, 0));
        c.add(this._atLeastComponent);
        return c;
    }

    private JComponent createIsRequiredComponent() {
        String label = LocalizedText.getText(ResourceKey.REQUIRED_LABEL);
        this._isRequiredComponent = ComponentFactory.createCheckBox(label);
        this._isRequiredComponent.addActionListener(this._buttonListener);
        return this._isRequiredComponent;
    }

    public Collection getValues() {
        Integer min = this._atLeastComponent.getValue();
        return CollectionUtilities.createCollection(min);
    }

    public void initialize() {
        JPanel panel = new JPanel(new GridLayout(1, 2));
        panel.add(this.createIsRequiredComponent());
        panel.add(this.createAtLeastComponent());
        this.add(new LabeledComponent(this.getLabel(), panel, false));
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return slot.getName().equals(":SLOT-MINIMUM-CARDINALITY");
    }

    public void setEditable(boolean editable) {
        this._isRequiredComponent.setEnabled(editable);
        this._atLeastComponent.setEnabled(editable);
    }

    public void setValues(Collection values) {
        Integer i = (Integer)MinimumCardinalityWidget.getFirstItem(values);
        boolean isRequired = i != null && i > 0;
        this._isRequiredComponent.setSelected(isRequired);
        if (isRequired) {
            this._atLeastComponent.setValue(i);
        } else {
            this._atLeastComponent.clearValue();
        }
    }

    public String getLabel() {
        return this.localizeStandardLabel(super.getLabel(), "Cardinality", ResourceKey.MINIMUM_CARDINALITY_SLOT_WIDGET_LABEL);
    }
}

