/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.util.ApplicationProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -1781140859643294527L;
    private static String COL_PROP = "Property";
    private static String COL_VAL = "Value";
    private static final int COL_PROP_COLNO = 0;
    private static final int COL_VAL_COLNO = 1;
    private Properties properties;
    private List<String> propertyList;
    private String[] columnNames = new String[]{COL_PROP, COL_VAL};
    private boolean changed = false;

    public PropertiesTableModel() {
        this(null);
    }

    public PropertiesTableModel(Properties properties) {
        this.setProperties(properties);
    }

    private ArrayList<String> fillPropertyList() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<?> e = this.properties.propertyNames();
        while (e.hasMoreElements()) {
            list.add((String)e.nextElement());
        }
        Collections.sort(list);
        return list;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.properties.size();
    }

    public Class getColumnClass(int colIndex) {
        switch (colIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.propertyList.get(rowIndex);
            }
            case 1: {
                String text = this.properties.getProperty(this.propertyList.get(rowIndex));
                return text;
            }
        }
        return new String("??");
    }

    public void addRow(String prop, String value) {
        this.properties.setProperty(prop, value);
        this.propertyList = this.fillPropertyList();
        this.changed = true;
        this.fireTableDataChanged();
    }

    public void deleteRow(int rowIndex) {
        String propName = this.propertyList.get(rowIndex);
        this.properties.remove(propName);
        this.propertyList = this.fillPropertyList();
        this.changed = true;
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                String oldPropName = this.propertyList.get(rowIndex);
                String value = this.properties.getProperty(oldPropName, "");
                String newPropName = (String)aValue;
                if (oldPropName.equals(newPropName)) {
                    return;
                }
                this.properties.setProperty(newPropName, value);
                this.properties.remove(oldPropName);
                this.propertyList = this.fillPropertyList();
                break;
            }
            case 1: {
                String propName = this.propertyList.get(rowIndex);
                String oldValue = this.properties.getProperty(propName, "");
                String newValue = (String)aValue;
                if (oldValue.equals(newValue)) {
                    return;
                }
                newValue = newValue.trim();
                this.properties.setProperty(propName, newValue);
                break;
            }
        }
        this.changed = true;
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public int getRowOfProperty(String propName) {
        return this.propertyList.indexOf(propName);
    }

    public int getRowOfPropertyValue(String value) {
        int row = -1;
        for (int i = 0; i < this.propertyList.size(); ++i) {
            if (!this.properties.getProperty(this.propertyList.get(i)).equals(value)) continue;
            return i;
        }
        return -1;
    }

    public static int getValueColumnIndex() {
        return 1;
    }

    public static int getPropertyColumnIndex() {
        return 0;
    }

    public void setProperties(Properties properties) {
        if (properties == null) {
            properties = ApplicationProperties.getApplicationProperties();
        }
        this.properties = properties;
        this.propertyList = this.fillPropertyList();
        this.changed = false;
        this.fireTableDataChanged();
    }

    public boolean isChanged() {
        return this.changed;
    }

    protected void setChanged(boolean changed) {
        this.changed = changed;
    }
}

