/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.ExtensionFilter;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableTable;
import edu.stanford.smi.protege.widget.PropertiesTableModel;
import edu.stanford.smi.protege.widget.TextAreaRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;

public class ProtegePropertiesComponent
extends JPanel {
    private static final long serialVersionUID = -5051686359840804602L;
    private SelectableTable _propertiesTable;
    private PropertiesTableModel _propertiesTableModel;
    private LabeledComponent _labeledComponent;
    private JLabel _warningLabel;
    private AllowableAction addAction;
    private AllowableAction viewAction;
    private AllowableAction deleteAction;
    private AllowableAction saveAction;
    private AllowableAction loadAction;
    private File lastDirectory = ApplicationProperties.getLastFileDirectory();
    private File _propertiesFile = null;

    public ProtegePropertiesComponent() {
        this.buildGUI(null);
    }

    public ProtegePropertiesComponent(Properties properties) {
        this.buildGUI(properties);
    }

    public ProtegePropertiesComponent(File propertyFile) {
        this.buildGUI(this.loadPropertyFile(propertyFile));
    }

    public void buildGUI(Properties properties) {
        this.setLayout(new BorderLayout());
        this._propertiesTable = new SelectableTable(){
            private static final long serialVersionUID = -7335109538274237998L;

            public void editingStopped(ChangeEvent e) {
                int newRow;
                int editingColumn = this.getEditingColumn();
                String cellValue = (String)this.getCellEditor().getCellEditorValue();
                super.editingStopped(e);
                if (editingColumn == PropertiesTableModel.getPropertyColumnIndex() && (newRow = ((PropertiesTableModel)this.getModel()).getRowOfProperty(cellValue)) >= 0) {
                    ComponentUtilities.scrollToVisible(ProtegePropertiesComponent.this._propertiesTable, newRow, PropertiesTableModel.getValueColumnIndex());
                    ProtegePropertiesComponent.this._propertiesTable.setRowSelectionInterval(newRow, newRow);
                    ProtegePropertiesComponent.this._propertiesTable.editCellAt(newRow, PropertiesTableModel.getValueColumnIndex());
                    ProtegePropertiesComponent.this._propertiesTable.requestFocus();
                }
            }
        };
        this._propertiesTableModel = new PropertiesTableModel(properties);
        this._propertiesTable.setModel(this._propertiesTableModel);
        this._propertiesTable.getColumnModel().getColumn(1).setCellRenderer(new TextAreaRenderer());
        this._propertiesTable.getTableHeader().setReorderingAllowed(false);
        this._labeledComponent = new LabeledComponent("Property Table", new JScrollPane(this._propertiesTable));
        this._warningLabel = new JLabel("", null, 0);
        this.viewAction = this.createViewAction();
        this.addAction = this.createAddAction();
        this.deleteAction = this.createDeleteAction();
        this.saveAction = this.createSaveAction();
        this.loadAction = this.createLoadAction();
        this.saveAction.setName("Save property file as ...");
        this.loadAction.setName("Load property file");
        this._labeledComponent.addHeaderButton(this.viewAction);
        this._labeledComponent.addHeaderButton(this.addAction);
        this._labeledComponent.addHeaderButton(this.deleteAction);
        this._labeledComponent.addHeaderButton(this.saveAction);
        this._labeledComponent.addHeaderButton(this.loadAction);
        this.add((Component)this._warningLabel, "North");
        this.add((Component)this._labeledComponent, "Center");
        this.updateLabel();
    }

    private AllowableAction createViewAction() {
        return new AllowableAction(ResourceKey.VALUE_VIEW, (Selectable)this._propertiesTable){
            private static final long serialVersionUID = -782664778236281392L;

            public void actionPerformed(ActionEvent e) {
                int selectedRow = ProtegePropertiesComponent.this._propertiesTable.getSelectedRow();
                String propName = (String)ProtegePropertiesComponent.this._propertiesTable.getValueAt(selectedRow, PropertiesTableModel.getPropertyColumnIndex());
                String propValue = (String)ProtegePropertiesComponent.this._propertiesTable.getValueAt(selectedRow, PropertiesTableModel.getValueColumnIndex());
                JPanel panel = new JPanel();
                panel.setLayout(new GridLayout());
                panel.setPreferredSize(new Dimension(300, 100));
                JTextArea textArea = new JTextArea();
                textArea.setLineWrap(true);
                textArea.setWrapStyleWord(true);
                textArea.setText(propName + " = " + propValue);
                textArea.setEnabled(false);
                panel.add(new JScrollPane(textArea));
                ModalDialog.showDialog(ProtegePropertiesComponent.this, panel, "View property value", 14);
            }
        };
    }

    private AllowableAction createAddAction() {
        return new AllowableAction(ResourceKey.VALUE_ADD){
            private static final long serialVersionUID = 4094647618090854671L;

            public void actionPerformed(ActionEvent arg0) {
                ((PropertiesTableModel)ProtegePropertiesComponent.this._propertiesTable.getModel()).addRow("", "");
                ProtegePropertiesComponent.this._propertiesTable.clearSelection();
                ComponentUtilities.scrollToVisible(ProtegePropertiesComponent.this._propertiesTable, 0, 0);
                ProtegePropertiesComponent.this._propertiesTable.setRowSelectionInterval(0, 0);
                ProtegePropertiesComponent.this._propertiesTable.editCellAt(0, 0);
                ProtegePropertiesComponent.this._propertiesTable.requestFocus();
            }
        };
    }

    private AllowableAction createDeleteAction() {
        return new AllowableAction(ResourceKey.VALUE_DELETE, (Selectable)this._propertiesTable){
            private static final long serialVersionUID = 5139197510485952863L;

            public void actionPerformed(ActionEvent arg0) {
                if (ProtegePropertiesComponent.this._propertiesTable.getCellEditor() != null) {
                    ProtegePropertiesComponent.this._propertiesTable.getCellEditor().stopCellEditing();
                }
                int selectedRow = ProtegePropertiesComponent.this._propertiesTable.getSelectedRow();
                ProtegePropertiesComponent.this._propertiesTableModel.deleteRow(selectedRow);
                if (ProtegePropertiesComponent.this._propertiesTableModel.getRowCount() > selectedRow) {
                    ProtegePropertiesComponent.this._propertiesTable.setRowSelectionInterval(selectedRow, selectedRow);
                }
            }
        };
    }

    private AllowableAction createSaveAction() {
        return new AllowableAction(ResourceKey.PROJECT_SAVE){
            private static final long serialVersionUID = 6607784184953248192L;

            public void actionPerformed(ActionEvent arg0) {
                ProtegePropertiesComponent.this.savePropertyFile();
            }
        };
    }

    private void savePropertyFile() {
        JFileChooser chooser = this.createFileChooser("Save property file", "Property Files", "", false);
        int openDialogResult = chooser.showSaveDialog(this);
        if (openDialogResult == 0) {
            File propFile = chooser.getSelectedFile();
            if (this.savePropertyFile(propFile)) {
                ModalDialog.showMessageDialog((Component)this, "Property file written out successfully to:\n" + propFile.getAbsolutePath(), "Property file saved");
            } else {
                ModalDialog.showMessageDialog((Component)this, "Error writing property file", "Error");
            }
        }
    }

    public boolean savePropertyFile(File propFile) {
        return this.savePropertyFile(propFile, false);
    }

    public boolean savePropertyFile(File propFile, boolean escapeColonChar) {
        try {
            FileOutputStream out = new FileOutputStream(propFile);
            if (escapeColonChar) {
                FileUtilities.savePropertiesFile(propFile, this._propertiesTableModel.getProperties());
            } else {
                this._propertiesTableModel.getProperties().store(out, "Generated by ProtegePropertyTab");
            }
            this._propertiesTableModel.setChanged(false);
            return true;
        }
        catch (Exception e) {
            Log.getLogger().warning("Could not write property file: " + propFile.getAbsolutePath());
            return false;
        }
    }

    private AllowableAction createLoadAction() {
        return new AllowableAction(ResourceKey.PROJECT_OPEN){
            private static final long serialVersionUID = 4999564289768724565L;

            public void actionPerformed(ActionEvent arg0) {
                JFileChooser chooser;
                int openDialogResult;
                int rval;
                if (ProtegePropertiesComponent.this.isChangedContent() && (rval = ModalDialog.showMessageDialog(ProtegePropertiesComponent.this, "Save current properties?", "Save", 13)) == 2) {
                    ProtegePropertiesComponent.this.savePropertyFile();
                }
                if ((openDialogResult = (chooser = ProtegePropertiesComponent.this.createFileChooser("Load property file", "Property files", "", true)).showOpenDialog(ProtegePropertiesComponent.this)) == 0) {
                    File propFile = chooser.getSelectedFile();
                    Properties properties = ProtegePropertiesComponent.this.loadPropertyFile(propFile);
                    ProtegePropertiesComponent.this._propertiesTableModel.setProperties(properties);
                    ProtegePropertiesComponent.this.updateLabel();
                }
            }
        };
    }

    private Properties loadPropertyFile(File propFile) {
        Properties properties = new Properties();
        try {
            FileInputStream is = new FileInputStream(propFile);
            properties.load(is);
            ((InputStream)is).close();
        }
        catch (Exception e) {
            ModalDialog.showMessageDialog((Component)this, "Error loading property file", "Error");
            Log.getLogger().warning("Could not open property file: " + propFile.getAbsolutePath());
        }
        this._propertiesFile = propFile;
        return properties;
    }

    public AllowableAction getAddAction() {
        return this.addAction;
    }

    public AllowableAction getDeleteAction() {
        return this.deleteAction;
    }

    public AllowableAction getLoadAction() {
        return this.loadAction;
    }

    public AllowableAction getSaveAction() {
        return this.saveAction;
    }

    public AllowableAction getViewAction() {
        return this.viewAction;
    }

    private JFileChooser createFileChooser(String title, String fileDescription, String fileExtension, final boolean overwriteWithoutConfirm) {
        JFileChooser chooser = new JFileChooser(this.lastDirectory){
            private static final long serialVersionUID = -3429961883209448355L;

            public int showDialog(Component c, String s) {
                int rval = super.showDialog(c, s);
                if (rval == 0) {
                    ProtegePropertiesComponent.this.lastDirectory = this.getCurrentDirectory();
                }
                return rval;
            }

            public void approveSelection() {
                String title;
                String msg;
                int option;
                if (overwriteWithoutConfirm) {
                    super.approveSelection();
                    return;
                }
                File f = this.getSelectedFile();
                if (f.exists() && (option = JOptionPane.showConfirmDialog(this, msg = "The file '" + f.getName() + "' already exists!\nDo you want to replace it?", title = this.getDialogTitle(), 0, 2)) == 1) {
                    return;
                }
                super.approveSelection();
            }
        };
        chooser.setDialogType(1);
        chooser.setDialogTitle(title);
        if (fileExtension != null && fileExtension.length() > 0) {
            String text = fileDescription;
            chooser.setFileFilter(new ExtensionFilter(fileExtension, text));
        }
        return chooser;
    }

    private void updateLabel() {
        String headerLabel = "Property Table    (" + (this._propertiesFile == null ? "protege.properties" : this._propertiesFile.getName()) + ")";
        this._labeledComponent.setHeaderLabel(headerLabel);
        if (this._propertiesFile != null) {
            this._warningLabel.setToolTipText(this._propertiesFile.getAbsolutePath());
        }
        this._warningLabel.setFont(new Font(null, 1, 12));
        this._warningLabel.setText(this._propertiesFile == null ? "" : "  Changes take effect after restarting " + Text.getProgramName());
        this._warningLabel.setIcon(this._propertiesFile == null ? null : Icons.getIcon(new ResourceKey("warning")));
    }

    public void setVisibleHeaderButton(AllowableAction buttonAction, boolean visible) {
        for (JButton button : this._labeledComponent.getHeaderButtons()) {
            if (button.getAction() != buttonAction) continue;
            button.setVisible(visible);
        }
    }

    public boolean isChangedContent() {
        return this._propertiesTableModel.isChanged();
    }

    public void stopCellEditing() {
        if (this._propertiesTable.getCellEditor() != null) {
            this._propertiesTable.getCellEditor().stopCellEditing();
        }
    }
}

