/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.RoleConstraint;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.widget.ComboBoxWidget;
import edu.stanford.smi.protege.widget.RoleRenderer;
import java.awt.Component;
import java.util.ArrayList;

public class RoleWidget
extends ComboBoxWidget {
    private static final long serialVersionUID = -6134697762789716619L;

    public void comboBoxValueChanged() {
        Object newValue = this.getComboBoxSelection();
        if (RoleConstraint.isAbstract((String)newValue)) {
            this.makeConcreteAbstract();
        } else {
            this.makeAbstractConcrete();
        }
    }

    private void makeAbstractConcrete() {
        this.valueChanged();
    }

    private void makeConcreteAbstract() {
        int instanceCount;
        Cls cls = (Cls)this.getInstance();
        int n = instanceCount = cls == null ? 0 : cls.getDirectInstanceCount();
        if (instanceCount > 0) {
            String s = instanceCount == 1 ? "" : "s";
            String text = "The class " + cls.getBrowserText();
            text = text + " has " + instanceCount + " direct instance" + s + ".\n";
            text = text + "Changing the role to \"abstract\" will cause these instances to be deleted.\n\n";
            int response = ModalDialog.showMessageDialog((Component)this, text = text + "Do you really want to make this change?", 13);
            if (response == 2) {
                for (Instance instance : new ArrayList<Instance>(cls.getDirectInstances())) {
                    instance.delete();
                }
                this.valueChanged();
            } else {
                this.setComboBoxValue("Concrete".toString());
            }
        } else {
            this.valueChanged();
        }
    }

    public void initialize() {
        this.setDisplayNullEntry(false);
        super.initialize();
        this.setRenderer(new RoleRenderer());
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return slot.getName().equals(":ROLE");
    }

    public String getLabel() {
        return this.localizeStandardLabel(super.getLabel(), "Role", ResourceKey.ROLE_SLOT_WIDGET_LABEL);
    }
}

