/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.FloatValidator;
import edu.stanford.smi.protege.util.IntegerValidator;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.NumberValidator;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractListWidget;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;

public class SlotValuesWidget
extends AbstractListWidget {
    private static final long serialVersionUID = 103665542520867791L;
    private Action _viewAction;
    private AllowableAction _createAction;
    private AllowableAction _addAction;
    private Action _removeAction;
    private ClsListener _clsListener = new ClsAdapter(){

        public void templateFacetValueChanged(ClsEvent event) {
            super.templateFacetValueChanged(event);
            if (event.getFacet().getName().equals(":VALUE-TYPE")) {
                SlotValuesWidget.this.updateButtons();
            }
        }
    };
    private FrameListener _frameListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent event) {
            super.ownSlotValueChanged(event);
            if (event.getSlot().getName().equals(":SLOT-VALUE-TYPE")) {
                SlotValuesWidget.this.updateButtons();
            }
        }
    };

    private Collection addItems() {
        Collection<String> items = null;
        ValueType type = this.getCurrentType();
        if (SlotValuesWidget.equals(type, ValueType.CLS)) {
            Collection c = this.getAllowedParents();
            items = DisplayUtilities.pickClses((Component)this, this.getKnowledgeBase(), c);
        } else if (SlotValuesWidget.equals(type, ValueType.INSTANCE)) {
            Collection c = this.getAllowedClses();
            items = DisplayUtilities.pickInstances((Component)this, this.getKnowledgeBase(), c);
        } else if (SlotValuesWidget.equals(type, ValueType.SYMBOL)) {
            items = CollectionUtilities.createCollection(this.editSymbol(null));
        } else {
            Log.getLogger().warning("bad type: " + type);
        }
        return items;
    }

    private Boolean editBoolean(Object o) {
        List<Object> c = Arrays.asList("true", "false");
        String s = o == null ? (String)null : o.toString();
        s = this.editSymbol(s, c);
        return s == null ? null : new Boolean(s);
    }

    private Object editItem(Object originalItem) {
        Object editedItem;
        ValueType type = this.getCurrentType();
        if (SlotValuesWidget.equals(type, ValueType.BOOLEAN)) {
            editedItem = this.editBoolean(originalItem);
        } else if (SlotValuesWidget.equals(type, ValueType.CLS)) {
            this.showInstance((Instance)originalItem);
            editedItem = originalItem;
        } else if (SlotValuesWidget.equals(type, ValueType.FLOAT)) {
            editedItem = this.editText("Float", originalItem, FloatValidator.getInstance());
        } else if (SlotValuesWidget.equals(type, ValueType.INSTANCE)) {
            if (originalItem == null) {
                Cls cls = DisplayUtilities.pickConcreteCls((Component)this, this.getKnowledgeBase(), this.getAllowedClses());
                editedItem = cls.createDirectInstance(null);
                this.showInstance((Instance)editedItem);
            } else {
                this.showInstance((Instance)originalItem);
                editedItem = originalItem;
            }
        } else if (SlotValuesWidget.equals(type, ValueType.INTEGER)) {
            editedItem = this.editText("Integer", originalItem, IntegerValidator.getInstance());
        } else if (SlotValuesWidget.equals(type, ValueType.STRING)) {
            editedItem = this.editText("String", originalItem, null);
        } else if (SlotValuesWidget.equals(type, ValueType.SYMBOL)) {
            editedItem = this.editSymbol(originalItem);
        } else {
            Log.getLogger().warning("bad type: " + type);
            editedItem = originalItem;
        }
        return editedItem;
    }

    private String editSymbol(Object o) {
        return this.editSymbol((String)o, this.getAllowedValues());
    }

    private String editSymbol(String value, Collection allowedValues) {
        return (String)DisplayUtilities.pickSymbol(this, "Value", value, allowedValues);
    }

    private Object editText(String name, Object o, NumberValidator v) {
        String text = DisplayUtilities.editString(this, name + " Value", o, v);
        Object output = text == null ? null : (v == null ? text : v.convertToNumber(text));
        return output;
    }

    private Action getAddAction() {
        this._addAction = new AddAction(ResourceKey.VALUE_ADD){
            private static final long serialVersionUID = -8390731086548880897L;

            public void onAdd() {
                Collection c = SlotValuesWidget.this.addItems();
                if (c != null) {
                    SlotValuesWidget.this.addItems(c);
                }
            }
        };
        return this._addAction;
    }

    private Slot getSlotInstance() {
        return (Slot)this.getInstance();
    }

    private Collection getAllowedClses() {
        Slot slot = this.getSlotInstance();
        Collection clses = this.isSlotAtCls() ? this.getAssociatedCls().getTemplateSlotAllowedClses(slot) : slot.getAllowedClses();
        return this.rootCollection(clses);
    }

    private Collection getAllowedParents() {
        Slot slot = this.getSlotInstance();
        Collection parents = this.isSlotAtCls() ? this.getAssociatedCls().getTemplateSlotAllowedParents(slot) : slot.getAllowedParents();
        return this.rootCollection(parents);
    }

    private Collection getAllowedValues() {
        Slot slot = this.getSlotInstance();
        Collection values = this.isSlotAtCls() ? this.getAssociatedCls().getTemplateSlotAllowedValues(slot) : slot.getAllowedValues();
        return values;
    }

    private Action getCreateAction() {
        this._createAction = new CreateAction(ResourceKey.VALUE_CREATE){
            private static final long serialVersionUID = -4397623316890492860L;

            public void onCreate() {
                Object o = SlotValuesWidget.this.editItem(null);
                if (o != null) {
                    SlotValuesWidget.this.addItem(o);
                }
            }
        };
        return this._createAction;
    }

    private ValueType getCurrentType() {
        Slot slot = this.getSlotInstance();
        ValueType type = slot == null ? ValueType.ANY : (this.isSlotAtCls() ? this.getAssociatedCls().getTemplateSlotValueType(slot) : slot.getValueType());
        return type;
    }

    private Action getEditAction() {
        this._viewAction = new ViewAction((Selectable)this){
            private static final long serialVersionUID = -7273113512035501651L;

            public void onView(Object o) {
                Object editedItem = SlotValuesWidget.this.editItem(o);
                if (!o.equals(editedItem)) {
                    SlotValuesWidget.this.replaceItem(o, editedItem);
                }
            }
        };
        return this._viewAction;
    }

    private Action getRemoveAction() {
        this._removeAction = new RemoveAction(ResourceKey.VALUE_REMOVE, (Selectable)this){
            private static final long serialVersionUID = -2334952871995157304L;

            public void onRemove(Collection values) {
                SlotValuesWidget.this.removeItems(values);
            }
        };
        return this._removeAction;
    }

    public void initialize() {
        Action editAction = this.getEditAction();
        super.initialize(editAction);
        this.addButton(editAction);
        this.addButton(this.getCreateAction());
        this.addButton(this.getAddAction());
        this.addButton(this.getRemoveAction());
        this.updateButtons();
    }

    private boolean isEditable() {
        Slot slot = this.getSlotInstance();
        boolean result = slot == null ? false : (this.isSlotAtCls() ? this.getAssociatedCls().isEditable() : slot.isEditable());
        result = result && !this.isReadOnlyConfiguredWidget();
        return result;
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return slot.getName().equals(":SLOT-VALUES");
    }

    private Collection rootCollection(Collection c) {
        return c.isEmpty() ? this.getKnowledgeBase().getRootClses() : c;
    }

    public void setInstance(Instance newInstance) {
        Instance oldInstance = this.getInstance();
        if (oldInstance != null) {
            oldInstance.removeFrameListener(this._frameListener);
        }
        super.setInstance(newInstance);
        if (newInstance != null) {
            newInstance.addFrameListener(this._frameListener);
        }
    }

    public void setAssociatedCls(Cls cls) {
        Cls oldAssociatedCls = this.getAssociatedCls();
        if (oldAssociatedCls != null) {
            oldAssociatedCls.removeClsListener(this._clsListener);
        }
        super.setAssociatedCls(cls);
        if (cls != null) {
            cls.addClsListener(this._clsListener);
        }
    }

    public void setValues(Collection c) {
        super.setValues(c);
        this.updateButtons();
    }

    private void updateButtons() {
        boolean fixedValueType;
        ValueType type = this.getCurrentType();
        boolean addAllowed = fixedValueType = SlotValuesWidget.equals(type, ValueType.INSTANCE) || SlotValuesWidget.equals(type, ValueType.CLS) || SlotValuesWidget.equals(type, ValueType.SYMBOL);
        this._addAction.setAllowed(addAllowed && this.isEditable());
        boolean createAllowed = !SlotValuesWidget.equals(type, ValueType.ANY) && !fixedValueType;
        this._createAction.setAllowed(createAllowed && this.isEditable());
    }

    public String getLabel() {
        return this.localizeStandardLabel(super.getLabel(), "Template Values", ResourceKey.TEMPLATE_VALUES_SLOT_WIDGET_LABEL);
    }
}

