/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.widget.SlotWidget;
import java.awt.Component;
import java.util.Comparator;

public class SlotWidgetComparer
implements Comparator {
    private static final int SINGLE = 0;
    private static final int MULTIPLE = 1;
    private static final int[][] _rank = new int[2][8];

    public int compare(Object o1, Object o2) {
        SlotWidget w1 = (SlotWidget)o1;
        SlotWidget w2 = (SlotWidget)o2;
        int diff = SlotWidgetComparer.getRank(w1) - SlotWidgetComparer.getRank(w2);
        if (diff == 0) {
            diff = ((Component)((Object)w1)).getHeight() - ((Component)((Object)w2)).getHeight();
        }
        if (diff == 0) {
            String s1 = w1.getLabel();
            String s2 = w2.getLabel();
            if (s1 == null || s2 == null) {
                Log.getLogger().warning("null label: " + o1 + " " + o2);
                diff = 0;
            } else {
                diff = s1.compareToIgnoreCase(s2);
            }
        }
        return diff;
    }

    private static int getRank(SlotWidget widget) {
        Cls cls = widget.getCls();
        Slot slot = widget.getSlot();
        boolean allowsMultiple = cls.getTemplateSlotAllowsMultipleValues(slot);
        ValueType type = cls.getTemplateSlotValueType(slot);
        return _rank[allowsMultiple ? 1 : 0][type.getIntValue()];
    }

    static {
        SlotWidgetComparer._rank[0][ValueType.ANY.getIntValue()] = 10;
        SlotWidgetComparer._rank[0][ValueType.BOOLEAN.getIntValue()] = 1;
        SlotWidgetComparer._rank[0][ValueType.CLS.getIntValue()] = 5;
        SlotWidgetComparer._rank[0][ValueType.FLOAT.getIntValue()] = 3;
        SlotWidgetComparer._rank[0][ValueType.INSTANCE.getIntValue()] = 6;
        SlotWidgetComparer._rank[0][ValueType.INTEGER.getIntValue()] = 2;
        SlotWidgetComparer._rank[0][ValueType.STRING.getIntValue()] = 0;
        SlotWidgetComparer._rank[0][ValueType.SYMBOL.getIntValue()] = 4;
        SlotWidgetComparer._rank[1][ValueType.ANY.getIntValue()] = 11;
        SlotWidgetComparer._rank[1][ValueType.BOOLEAN.getIntValue()] = 7;
        SlotWidgetComparer._rank[1][ValueType.CLS.getIntValue()] = 8;
        SlotWidgetComparer._rank[1][ValueType.FLOAT.getIntValue()] = 7;
        SlotWidgetComparer._rank[1][ValueType.INSTANCE.getIntValue()] = 9;
        SlotWidgetComparer._rank[1][ValueType.INTEGER.getIntValue()] = 7;
        SlotWidgetComparer._rank[1][ValueType.STRING.getIntValue()] = 7;
        SlotWidgetComparer._rank[1][ValueType.SYMBOL.getIntValue()] = 7;
    }
}

