/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractListWidget;
import java.util.Collection;
import javax.swing.Action;

public class StringListWidget
extends AbstractListWidget {
    private static final long serialVersionUID = 5874778974979833802L;
    private AllowableAction _createAction;
    private AllowableAction _removeAction;

    private Action getCreateAction() {
        this._createAction = new CreateAction(ResourceKey.VALUE_ADD){
            private static final long serialVersionUID = 4889608712670405498L;

            public void onCreate() {
                StringListWidget.this.handleCreateAction();
            }
        };
        return this._createAction;
    }

    private Action getEditAction() {
        return new ViewAction(ResourceKey.VALUE_VIEW, (Selectable)this){
            private static final long serialVersionUID = -1543226916049064459L;

            public void onView(Object o) {
                StringListWidget.this.handleViewAction((String)o);
            }
        };
    }

    private Action getRemoveAction() {
        this._removeAction = new RemoveAction(ResourceKey.VALUE_REMOVE, (Selectable)this){
            private static final long serialVersionUID = -7407688724548195021L;

            public void onRemove(Collection strings) {
                StringListWidget.this.handleRemoveAction(strings);
            }
        };
        return this._removeAction;
    }

    protected void handleCreateAction() {
        String s = DisplayUtilities.editString(this, "Create String Value", null, null);
        if (s != null) {
            this.addItem(s);
        }
    }

    protected void handleRemoveAction(Collection strings) {
        this.removeItems(strings);
    }

    protected void handleViewAction(String str) {
        String s = DisplayUtilities.editString(this, "Edit String Value", str, null);
        if (s != null) {
            this.replaceItem(str, s);
        }
    }

    public void initialize() {
        Action editAction = this.getEditAction();
        super.initialize(editAction);
        this.addButton(editAction);
        this.addButton(this.getCreateAction());
        this.addButton(this.getRemoveAction());
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean isSuitable;
        if (cls == null || slot == null) {
            isSuitable = false;
        } else {
            boolean isString = StringListWidget.equals(cls.getTemplateSlotValueType(slot), ValueType.STRING);
            boolean isMultiple = cls.getTemplateSlotAllowsMultipleValues(slot);
            isSuitable = isString && isMultiple;
        }
        return isSuitable;
    }

    public void setEditable(boolean b) {
        b = b && !this.isReadOnlyConfiguredWidget();
        this._createAction.setAllowed(b);
        this._removeAction.setAllowed(b);
    }
}

