/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractListWidget;
import java.util.Collection;
import javax.swing.Action;

public class SymbolListWidget
extends AbstractListWidget {
    private static final long serialVersionUID = -5238094337376212437L;

    private String edit(String label, Object initialValue) {
        Collection allowedValues = this.getCls().getTemplateSlotAllowedValues(this.getSlot());
        return (String)DisplayUtilities.pickSymbol(this, label, initialValue, allowedValues);
    }

    private Action getCreateAction() {
        return new CreateAction(ResourceKey.VALUE_ADD){
            private static final long serialVersionUID = -5937947639182802969L;

            public void onCreate() {
                SymbolListWidget.this.handleCreateAction();
            }
        };
    }

    private Action getEditAction() {
        return new ViewAction(ResourceKey.VALUE_VIEW, (Selectable)this){
            private static final long serialVersionUID = -6781849184410952271L;

            public void onView(Object o) {
                SymbolListWidget.this.handleViewAction((String)o);
            }
        };
    }

    private Action getRemoveAction() {
        return new RemoveAction(ResourceKey.VALUE_REMOVE, (Selectable)this){
            private static final long serialVersionUID = -6176315941870004648L;

            public void onRemove(Collection values) {
                SymbolListWidget.this.handleRemoveAction(values);
            }
        };
    }

    protected void handleCreateAction() {
        String s = this.edit("Create Symbol", null);
        if (s != null) {
            this.addItem(s);
        }
    }

    protected void handleRemoveAction(Collection values) {
        this.removeItems(values);
    }

    protected void handleViewAction(String symbol) {
        String s = this.edit("Edit Symbol", symbol);
        if (s != null) {
            this.replaceItem(symbol, s);
        }
    }

    public void initialize() {
        Action editAction = this.getEditAction();
        super.initialize(editAction);
        this.addButton(editAction);
        this.addButton(this.getCreateAction());
        this.addButton(this.getRemoveAction());
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean isSuitable;
        if (cls == null || slot == null) {
            isSuitable = false;
        } else {
            boolean isString = SymbolListWidget.equals(cls.getTemplateSlotValueType(slot), ValueType.SYMBOL);
            boolean isMultiple = cls.getTemplateSlotAllowsMultipleValues(slot);
            isSuitable = isString && isMultiple;
        }
        return isSuitable;
    }
}

