/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.ValueTypeConstraint;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ListSelectionListenerAdapter;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.SymbolValidator;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractValuesComponent;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JScrollPane;

class SymbolValuesComponent
extends AbstractValuesComponent
implements Selectable {
    private static final long serialVersionUID = 3508078941013882199L;
    private SelectableList _list;
    private AllowableAction _createAction;
    private AllowableAction _editAction;
    private AllowableAction _removeAction;

    public SymbolValuesComponent() {
        Action editAction = this.getEditAction();
        this._list = ComponentFactory.createSelectableList(editAction, true);
        this._list.addListSelectionListener(new ListSelectionListenerAdapter(this));
        String text = LocalizedText.getText(ResourceKey.ALLOWED_VALUES);
        LabeledComponent c = new LabeledComponent(text, new JScrollPane(this._list));
        c.addHeaderButton(editAction);
        c.addHeaderButton(this.getCreateAction());
        c.addHeaderButton(this.getRemoveAction());
        this.add(c);
    }

    public void clearSelection() {
        this._list.clearSelection();
    }

    private Action getCreateAction() {
        this._createAction = new CreateAction(ResourceKey.VALUE_CREATE){
            private static final long serialVersionUID = -3411238108344825853L;

            public void onCreate() {
                String s = DisplayUtilities.editString(SymbolValuesComponent.this._list, "Create Symbol", null, new SymbolValidator());
                if (s != null && s.length() > 0) {
                    ComponentUtilities.addUniqueListValues(SymbolValuesComponent.this._list, CollectionUtilities.createCollection(s));
                    SymbolValuesComponent.this.valueChanged();
                }
            }
        };
        return this._createAction;
    }

    private Action getEditAction() {
        this._editAction = new ViewAction(ResourceKey.VALUE_VIEW, (Selectable)this){
            private static final long serialVersionUID = -1379237486395269996L;

            public void onView(Object o) {
                String s = DisplayUtilities.editString(SymbolValuesComponent.this._list, "Edit Symbol", o, new SymbolValidator());
                if (s != null) {
                    ComponentUtilities.replaceListValue(SymbolValuesComponent.this._list, o, s);
                    SymbolValuesComponent.this.valueChanged();
                }
            }
        };
        return this._editAction;
    }

    private Action getRemoveAction() {
        this._removeAction = new RemoveAction(ResourceKey.VALUE_REMOVE, (Selectable)this){
            private static final long serialVersionUID = 3520724966158279341L;

            public void onRemove(Collection values) {
                ComponentUtilities.removeListValues(SymbolValuesComponent.this._list, values);
                SymbolValuesComponent.this.valueChanged();
            }
        };
        return this._removeAction;
    }

    public Collection getSelection() {
        return this._list.getSelection();
    }

    public Collection getValues() {
        Collection values = ComponentUtilities.getListValues(this._list);
        return ValueTypeConstraint.getValues(ValueType.SYMBOL, values);
    }

    public void setEditable(boolean b) {
        this._createAction.setAllowed(b);
        this._editAction.setAllowed(b);
        this._removeAction.setAllowed(b);
    }

    public void setValues(Collection values) {
        Collection allowedValues = ValueTypeConstraint.getAllowedValues(values);
        ComponentUtilities.setListValues(this._list, allowedValues);
    }
}

