/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.event.KnowledgeBaseAdapter;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.FrameSlotCombination;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.CardinalityFacetRenderer;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.OtherFacetsRenderer;
import edu.stanford.smi.protege.ui.SlotPairRenderer;
import edu.stanford.smi.protege.ui.TypeFacetRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.RowTableModel;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.TransferableCollection;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractTableWidget;
import edu.stanford.smi.protege.widget.SlotViewPanel;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import javax.swing.table.TableModel;

public class TemplateSlotsWidget
extends AbstractTableWidget {
    private static final long serialVersionUID = 2572403293207051303L;
    private AllowableAction _viewAction;
    private AllowableAction _viewAtClsAction;
    protected AllowableAction _createAction;
    private AllowableAction _addAction;
    private AllowableAction _removeAction;
    private AllowableAction _removeOverrideAction;
    private Collection _currentClsTemplateSlots;
    private ClsListener _clsListener = new ClsAdapter(){

        public void templateSlotAdded(ClsEvent event) {
            Slot slot = event.getSlot();
            slot.addFrameListener(TemplateSlotsWidget.this._slotListener);
            TemplateSlotsWidget.this._currentClsTemplateSlots.add(slot);
            TemplateSlotsWidget.this.reload();
        }

        public void templateSlotRemoved(ClsEvent event) {
            Slot slot = event.getSlot();
            slot.removeFrameListener(TemplateSlotsWidget.this._slotListener);
            TemplateSlotsWidget.this._currentClsTemplateSlots.remove(slot);
            TemplateSlotsWidget.this.reload();
        }

        public void templateFacetValueChanged(ClsEvent event) {
            TemplateSlotsWidget.this.repaint();
        }

        public void directSuperclassAdded(ClsEvent event) {
            TemplateSlotsWidget.this.reload();
        }

        public void directSuperclassRemoved(ClsEvent event) {
            TemplateSlotsWidget.this.reload();
        }
    };
    private FrameListener _slotListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent event) {
            super.ownSlotValueChanged(event);
            TemplateSlotsWidget.this.repaint();
        }
    };
    private KnowledgeBaseListener _knowledgeBaseListener = new KnowledgeBaseAdapter(){

        public void frameReplaced(KnowledgeBaseEvent event) {
            TemplateSlotsWidget.this.reload();
        }
    };

    protected void addInheritedTemplateSlots(Collection slots, Cls cls) {
        for (Cls superclass : cls.getSuperclasses()) {
            TemplateSlotsWidget.addDirectTemplateSlots(slots, superclass);
        }
    }

    private void addSlots(Collection c) {
        Cls cls = this.getBoundCls();
        for (Slot slot : c) {
            this.addDirectTemplateSlot(cls, slot);
        }
    }

    private void addDirectTemplateSlot(Cls cls, Slot slot) {
        cls.addDirectTemplateSlot(slot);
        if (cls.isSlotMetaCls() && slot.getAssociatedFacet() == null) {
            Facet facet = this.getKnowledgeBase().createFacet(null);
            slot.setAssociatedFacet(facet);
        }
    }

    private boolean isSorting() {
        return !this.hasButton(Icons.getUpIcon());
    }

    protected void addTemplateSlots(Collection slots, Cls cls) {
        ArrayList templateSlots = new ArrayList(cls.getVisibleTemplateSlots());
        if (this.isSorting()) {
            Collections.sort(templateSlots);
        }
        slots.addAll(templateSlots);
    }

    private static void addDirectTemplateSlots(Collection slots, Cls cls) {
        for (Slot slot : TemplateSlotsWidget.getDirectTemplateSlots(cls)) {
            if (slots.contains(slot)) continue;
            slots.add(slot);
        }
    }

    private static Collection getDirectTemplateSlots(Cls cls) {
        return cls.getDirectTemplateSlots();
    }

    private void changeSlotIndex(Slot slot, int delta) {
        List slots = (List)this.getBoundCls().getDirectTemplateSlots();
        int oldIndex = slots.indexOf(slot);
        int newIndex = oldIndex + delta;
        if (0 <= newIndex && newIndex < slots.size()) {
            this.getBoundCls().moveDirectTemplateSlot(slot, newIndex);
            this.reload();
        }
    }

    private Action createMoveDownAction() {
        return new AbstractAction("Move down", Icons.getDownIcon()){
            private static final long serialVersionUID = -2706470541341140481L;
            {
                this.putValue("ShortDescription", "Move selected slot down");
            }

            public void actionPerformed(ActionEvent event) {
                TemplateSlotsWidget.this.handleMoveDownAction();
            }
        };
    }

    private Action createMoveUpAction() {
        return new AbstractAction("Move up", Icons.getUpIcon()){
            private static final long serialVersionUID = -5564065775845561448L;
            {
                this.putValue("ShortDescription", "Move selected slot up");
            }

            public void actionPerformed(ActionEvent event) {
                TemplateSlotsWidget.this.handleMoveUpAction();
            }
        };
    }

    public TableModel createTableModel() {
        Cls cls = (Cls)this.getInstance();
        List slots = cls == null ? Collections.EMPTY_LIST : this.getSlots(cls);
        RowTableModel model = new RowTableModel(this.getTable());
        for (Slot slot : slots) {
            FrameSlotCombination o = new FrameSlotCombination(cls, slot);
            model.addRow(o);
        }
        return model;
    }

    public void dispose() {
        super.dispose();
        this.getKnowledgeBase().removeKnowledgeBaseListener(this._knowledgeBaseListener);
        Cls cls = (Cls)this.getInstance();
        if (cls != null) {
            cls.removeClsListener(this._clsListener);
        }
    }

    public Action getAddSlotsAction() {
        this._addAction = new AddAction(ResourceKey.SLOT_ADD){
            private static final long serialVersionUID = 1413481816474864898L;

            public void onAdd() {
                Cls slotMetaCls = TemplateSlotsWidget.this.getBaseAllowedSlotMetaCls();
                ArrayList<Instance> slots = new ArrayList<Instance>(TemplateSlotsWidget.this.getKnowledgeBase().getInstances(slotMetaCls));
                slots.removeAll(TemplateSlotsWidget.this.getBoundCls().getTemplateSlots());
                String label = "Select " + TemplateSlotsWidget.this.getLabel();
                TemplateSlotsWidget.this.addSlots(DisplayUtilities.pickSlots(TemplateSlotsWidget.this, slots, label));
            }
        };
        return this._addAction;
    }

    private Cls getBaseAllowedSlotMetaCls() {
        Collection allowedClses = this.getBoundCls().getDirectType().getTemplateSlotAllowedClses(this.getSlot());
        return (Cls)CollectionUtilities.getFirstItem(allowedClses);
    }

    protected Cls getBaseSlotMetaCls() {
        Cls facetSlotMetaCls;
        Cls kbSlotMetaCls = this.getKnowledgeBase().getDefaultSlotMetaCls();
        Cls baseSlotMetaCls = kbSlotMetaCls.hasSuperclass(facetSlotMetaCls = this.getBaseAllowedSlotMetaCls()) ? kbSlotMetaCls : facetSlotMetaCls;
        return baseSlotMetaCls;
    }

    private Cls getBoundCls() {
        return (Cls)this.getInstance();
    }

    protected Action getCreateSlotAction() {
        this._createAction = new CreateAction(ResourceKey.SLOT_CREATE){
            private static final long serialVersionUID = 2685200630532658984L;

            public void onCreate() {
                Cls cls = TemplateSlotsWidget.this.getBoundCls();
                if (cls.isEditable()) {
                    KnowledgeBase kb = TemplateSlotsWidget.this.getKnowledgeBase();
                    Cls slotMetaCls = kb.getDefaultSlotMetaCls();
                    if (slotMetaCls == null || !TemplateSlotsWidget.this.getBaseSlotMetaCls().equals(slotMetaCls)) {
                        Collection allowedClses = cls.getDirectType().getTemplateSlotAllowedClses(TemplateSlotsWidget.this.getSlot());
                        slotMetaCls = DisplayUtilities.pickConcreteCls((Component)TemplateSlotsWidget.this, TemplateSlotsWidget.this.getKnowledgeBase(), allowedClses);
                    }
                    if (slotMetaCls != null) {
                        Slot slot = TemplateSlotsWidget.this.getKnowledgeBase().createSlot(null, slotMetaCls);
                        TemplateSlotsWidget.this.addDirectTemplateSlot(cls, slot);
                        TemplateSlotsWidget.this.showInstance(slot);
                    }
                }
            }
        };
        return this._createAction;
    }

    public Action getDoubleClickAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 940934952598817850L;

            public void actionPerformed(ActionEvent event) {
                SlotViewPanel panel;
                int result;
                FrameSlotCombination c = (FrameSlotCombination)CollectionUtilities.getFirstItem(TemplateSlotsWidget.this.getSelection());
                if (c != null && (result = ModalDialog.showDialog(TemplateSlotsWidget.this, panel = new SlotViewPanel(), "Select Slot View", 11)) == 1) {
                    if (panel.viewTopLevelSlot()) {
                        TemplateSlotsWidget.this._viewAction.actionPerformed(event);
                    } else {
                        TemplateSlotsWidget.this._viewAtClsAction.actionPerformed(event);
                    }
                }
            }
        };
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this._viewAction);
        menu.add(this._viewAtClsAction);
        menu.add(this._createAction);
        menu.add(this._addAction);
        menu.add(this._removeAction);
        return menu;
    }

    public Action getRemoveOverrideAction() {
        this._removeOverrideAction = new AllowableAction(ResourceKey.SLOT_REMOVE_FACET_OVERRIDES, (Selectable)this){
            private static final long serialVersionUID = -4145394593794210979L;

            public void actionPerformed(ActionEvent event) {
                for (FrameSlotCombination pair : this.getSelection()) {
                    ((Cls)pair.getFrame()).removeTemplateFacetOverrides(pair.getSlot());
                }
            }
        };
        return this._removeOverrideAction;
    }

    public Action getRemoveSlotsAction() {
        this._removeAction = new RemoveAction(ResourceKey.SLOT_REMOVE, (Selectable)this){
            private static final long serialVersionUID = -5482243741134967499L;

            public void onRemove(Collection combinations) {
                TemplateSlotsWidget.this.handleRemoveCombinations(combinations);
            }

            public void onSelectionChange() {
                Object o = CollectionUtilities.getFirstItem(this.getSelection());
                FrameSlotCombination combination = (FrameSlotCombination)o;
                Slot slot = combination == null ? (Slot)null : combination.getSlot();
                this.setAllowed(slot != null && TemplateSlotsWidget.this.getBoundCls().hasDirectTemplateSlot(slot));
            }
        };
        return this._removeAction;
    }

    protected void handleRemoveCombinations(Collection combinations) {
        try {
            Cls cls = this.getCls();
            this.beginTransaction("Remove slots from " + cls, cls == null ? null : cls.getName());
            for (FrameSlotCombination combination : combinations) {
                TemplateSlotsWidget.handleRemoveCombination(combination);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction();
            Log.getLogger().warning("Problem at removing slots from " + this.getCls());
        }
    }

    private static void handleRemoveCombination(FrameSlotCombination combination) {
        Cls cls = (Cls)combination.getFrame();
        Slot slot = combination.getSlot();
        cls.removeDirectTemplateSlot(slot);
    }

    private Slot getSelectedDirectSlot() {
        Slot slot = this.getSelectedSlot();
        boolean isDirect = this.getBoundCls().hasDirectTemplateSlot(slot);
        return isDirect ? slot : null;
    }

    private Slot getSelectedSlot() {
        Slot slot = null;
        Collection c = this.getSelection();
        if (c.size() == 1) {
            FrameSlotCombination combo = (FrameSlotCombination)CollectionUtilities.getFirstItem(c);
            slot = combo.getSlot();
        }
        return slot;
    }

    protected List getSlots(Cls cls) {
        ArrayList slots = new ArrayList();
        this.addTemplateSlots(slots, cls);
        return slots;
    }

    private Action getViewSlotAction() {
        this._viewAction = new ViewAction(ResourceKey.SLOT_VIEW_TOP_LEVEL, (Selectable)this){
            private static final long serialVersionUID = 7903942567777207326L;

            public void onView(Object o) {
                FrameSlotCombination combination = (FrameSlotCombination)o;
                TemplateSlotsWidget.this.showInstance(combination.getSlot());
            }
        };
        return this._viewAction;
    }

    private Action getViewSlotAtClassAction() {
        this._viewAtClsAction = new ViewAction(ResourceKey.SLOT_VIEW_FACET_OVERRIDES, (Selectable)this){
            private static final long serialVersionUID = -309920053960064704L;

            public void onView(Object o) {
                FrameSlotCombination combination = (FrameSlotCombination)o;
                TemplateSlotsWidget.this.show((Cls)combination.getFrame(), combination.getSlot());
            }
        };
        return this._viewAtClsAction;
    }

    protected void handleMoveDownAction() {
        Slot slot = this.getSelectedDirectSlot();
        if (slot != null) {
            this.changeSlotIndex(slot, 1);
        }
    }

    protected void handleMoveUpAction() {
        Slot slot = this.getSelectedDirectSlot();
        if (slot != null) {
            this.changeSlotIndex(slot, -1);
        }
    }

    public void initialize() {
        Action viewSlotAction = this.getViewSlotAction();
        super.initialize(this.getDoubleClickAction());
        this.addButton(viewSlotAction);
        this.addButton(this.getViewSlotAtClassAction());
        this.addButton(this.getCreateSlotAction());
        this.addButton(this.getRemoveOverrideAction());
        this.addButton(this.getAddSlotsAction());
        this.addButton(this.getRemoveSlotsAction());
        this.addButton(this.createMoveUpAction(), false);
        this.addButton(this.createMoveDownAction(), false);
        this.addColumn(200, ResourceKey.TEMPLATE_SLOTS_SLOT_WIDGET_NAME, SlotPairRenderer.createInstance());
        this.addColumn(80, ResourceKey.TEMPLATE_SLOTS_SLOT_WIDGET_CARDINALITY, new CardinalityFacetRenderer(this.getKnowledgeBase()));
        this.addColumn(200, ResourceKey.TEMPLATE_SLOTS_SLOT_WIDGET_TYPE, new TypeFacetRenderer());
        this.addColumn(400, ResourceKey.TEMPLATE_SLOTS_SLOT_WIDGET_OTHER_FACETS, new OtherFacetsRenderer());
        this.getTable().setAutoCreateColumnsFromModel(false);
        this.getKnowledgeBase().addKnowledgeBaseListener(this._knowledgeBaseListener);
        this.setupDragAndDrop();
    }

    private void setupDragAndDrop() {
        this.getTable().setDragEnabled(true);
        this.getTable().setTransferHandler(new MyTransferHandler());
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean isMetacls = cls.isClsMetaCls();
        Slot templateSlotsSlot = slot.getKnowledgeBase().getSlot(":DIRECT-TEMPLATE-SLOTS");
        return isMetacls && (slot.equals(templateSlotsSlot) || slot.hasSuperslot(templateSlotsSlot));
    }

    public void setEditable(boolean b) {
        this._createAction.setAllowed(b);
        this._addAction.setAllowed(b);
        this._removeAction.setAllowed(b);
        this._removeOverrideAction.setAllowed(b);
    }

    public void setInstance(Instance instance) {
        Cls currentCls = (Cls)this.getInstance();
        if (currentCls != null) {
            currentCls.removeClsListener(this._clsListener);
            for (Slot slot : this._currentClsTemplateSlots) {
                slot.removeFrameListener(this._slotListener);
            }
        }
        super.setInstance(instance);
        if (instance != null) {
            Cls cls = (Cls)instance;
            cls.addClsListener(this._clsListener);
            this._currentClsTemplateSlots = new ArrayList<Slot>(cls.getTemplateSlots());
            for (Slot slot : this._currentClsTemplateSlots) {
                slot.addFrameListener(this._slotListener);
            }
        }
    }

    public String getLabel() {
        return this.localizeStandardLabel(super.getLabel(), "Template Slots", ResourceKey.TEMPLATE_SLOTS_SLOT_WIDGET_LABEL);
    }

    public String toString() {
        return "TemplateSlotsWidget";
    }

    private class MyTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -3916638445633449129L;

        private MyTransferHandler() {
        }

        private Collection getTransferableCombinations() {
            ArrayList transferableCombinations = new ArrayList(TemplateSlotsWidget.this.getSelection());
            for (FrameSlotCombination combo : transferableCombinations) {
                Slot slot;
                Cls cls = (Cls)combo.getFrame();
                if (cls.hasDirectTemplateSlot(slot = combo.getSlot())) continue;
                transferableCombinations.clear();
                break;
            }
            return transferableCombinations;
        }

        protected Transferable createTransferable(JComponent c) {
            Collection collection = this.getTransferableCombinations();
            return collection.isEmpty() ? null : new TransferableCollection(collection);
        }

        protected void exportDone(JComponent source, Transferable data, int action) {
            if (action == 2) {
                for (FrameSlotCombination combo : this.getTransferableCombinations()) {
                    ((Cls)combo.getFrame()).removeDirectTemplateSlot(combo.getSlot());
                }
            }
        }

        public int getSourceActions(JComponent c) {
            return 3;
        }
    }
}

