/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.DocumentChangedListener;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.ReadOnlyWidgetConfigurationPanel;
import edu.stanford.smi.protege.widget.WidgetConfigurationPanel;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.text.JTextComponent;

public abstract class TextComponentWidget
extends AbstractSlotWidget {
    private static final long serialVersionUID = 1963540984949148931L;
    private static final Color INVALID_COLOR = Color.red;
    private JTextComponent _textComponent;
    private Color _defaultColor;
    private boolean _isDirty;
    private DocumentChangedListener _documentListener = new DocumentChangedListener(){

        public void stateChanged(ChangeEvent event) {
            TextComponentWidget.this.onTextChange();
        }
    };
    private FocusListener _focusListener = new FocusAdapter(){

        public void focusLost(FocusEvent event) {
            TextComponentWidget.this.commitChanges();
        }
    };
    private KeyListener _keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 10) {
                TextComponentWidget.this.commitChanges();
            }
        }
    };

    public void commitChanges() {
        this.onCommit();
        if (this._isDirty) {
            this.valueChanged();
        }
    }

    protected void onCommit() {
    }

    protected Collection createActions() {
        return Collections.EMPTY_LIST;
    }

    private void onTextChange() {
        this.validateText(this.getText());
        this._isDirty = true;
    }

    protected abstract JTextComponent createTextComponent();

    protected abstract JComponent createCenterComponent(JTextComponent var1);

    public void dispose() {
        this.commitChanges();
        if (this._textComponent != null) {
            try {
                this._textComponent.getDocument().removeDocumentListener(this._documentListener);
                this._textComponent.removeFocusListener(this._focusListener);
                this._textComponent.removeKeyListener(this._keyListener);
            }
            catch (Exception e) {
                Log.emptyCatchBlock(e);
            }
        }
        this._documentListener = null;
        this._focusListener = null;
        this._keyListener = null;
        super.dispose();
    }

    protected String getInvalidTextDescription(String text) {
        return null;
    }

    public String getText() {
        String s = this._textComponent.getText().trim();
        return s.length() == 0 ? null : s;
    }

    public JTextComponent getTextComponent() {
        return this._textComponent;
    }

    public void markDirty(boolean b) {
        this._isDirty = b;
    }

    public void setInstanceValues() {
        super.setInstanceValues();
        this._isDirty = false;
    }

    public Collection getValues() {
        String s = this.getText();
        return CollectionUtilities.createList(s);
    }

    public void initialize(boolean isStretchable, int nColumns, int nRows) {
        this.initialize(isStretchable, false, nColumns, nRows);
    }

    public void initialize(boolean isStretchable, boolean isSwappedHeader, int nColumns, int nRows) {
        this._textComponent = this.createTextComponent();
        this._textComponent.getDocument().addDocumentListener(this._documentListener);
        this._textComponent.addFocusListener(this._focusListener);
        this._textComponent.addKeyListener(this._keyListener);
        this.setEditable(true);
        this._defaultColor = this._textComponent.getForeground();
        JComponent centerComponent = this.createCenterComponent(this._textComponent);
        LabeledComponent labeledComponent = new LabeledComponent(this.getLabel(), centerComponent, isStretchable, isSwappedHeader);
        for (Action action : this.createActions()) {
            labeledComponent.addHeaderButton(action);
        }
        this.add(labeledComponent);
        this.setPreferredColumns(nColumns);
        this.setPreferredRows(nRows);
    }

    public boolean isEditable() {
        return this._textComponent.isEditable();
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean isSuitable;
        if (cls == null || slot == null) {
            isSuitable = false;
        } else {
            ValueType type = cls.getTemplateSlotValueType(slot);
            boolean isString = type == ValueType.STRING;
            boolean isSymbol = type == ValueType.SYMBOL;
            boolean isMultiple = cls.getTemplateSlotAllowsMultipleValues(slot);
            isSuitable = (isString || isSymbol) && !isMultiple;
        }
        return isSuitable;
    }

    public void selectAll() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TextComponentWidget.this._textComponent.selectAll();
                TextComponentWidget.this._textComponent.requestFocus();
            }
        });
    }

    public void setEditable(boolean b) {
        b = b && !this.isReadOnlyConfiguredWidget();
        this._textComponent.setEditable(b);
    }

    public void setText(String text) {
        if (this._documentListener != null) {
            this._documentListener.disable();
        }
        this._textComponent.setText(text == null ? "" : text);
        this.onSetText(text);
        if (this._documentListener != null) {
            this._documentListener.enable();
        }
        this.validateText(text);
    }

    protected void onSetText(String text) {
    }

    public void setInstance(Instance instance) {
        if (this._isDirty) {
            this.valueChanged();
        }
        super.setInstance(instance);
    }

    public void setValues(Collection values) {
        Object o = CollectionUtilities.getFirstItem(values);
        String text = o == null ? (String)null : o.toString();
        this.setText(text);
    }

    protected boolean validateText(String text) {
        String errorDescription;
        String string = errorDescription = text == null ? null : this.getInvalidTextDescription(text);
        if (errorDescription == null) {
            this._textComponent.setForeground(this._defaultColor);
            this._textComponent.setToolTipText(null);
        } else {
            this._textComponent.setForeground(INVALID_COLOR);
            this._textComponent.setToolTipText(errorDescription);
        }
        return errorDescription == null;
    }

    public WidgetConfigurationPanel createWidgetConfigurationPanel() {
        WidgetConfigurationPanel confPanel = super.createWidgetConfigurationPanel();
        confPanel.addTab("Options", new ReadOnlyWidgetConfigurationPanel(this));
        return confPanel;
    }
}

