/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.Hyperactive;
import edu.stanford.smi.protege.widget.TextComponentWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class URLWidget
extends TextComponentWidget {
    private static final long serialVersionUID = -6468403747924085772L;
    private JEditorPane urlDisplay;

    public void initialize() {
        this.initialize(true, 2, 2);
    }

    protected JTextComponent createTextComponent() {
        return ComponentFactory.createTextField();
    }

    protected void onCommit() {
        super.onCommit();
        this.updateURLDisplay();
    }

    protected JComponent createCenterComponent(JTextComponent textComponent) {
        this.urlDisplay = ComponentFactory.createEditorPane();
        this.urlDisplay.setEditable(false);
        this.urlDisplay.addHyperlinkListener(new Hyperactive());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)textComponent, "North");
        panel.add((Component)new JScrollPane(this.urlDisplay), "Center");
        return panel;
    }

    protected Action createHomeAction() {
        return new AbstractAction("Home", Icons.getHomeIcon()){
            private static final long serialVersionUID = -3490306473291374592L;

            public void actionPerformed(ActionEvent events) {
                URLWidget.this.updateURLDisplay();
            }
        };
    }

    protected Action createViewAction() {
        return new ViewAction(ResourceKey.URL_VIEW_IN_BROWSER, null){
            private static final long serialVersionUID = 4535338964946498034L;

            public void onView() {
                URL url = URLWidget.this.getCurrentURL();
                if (url != null) {
                    SystemUtilities.showHTML(url.toString());
                }
            }
        };
    }

    protected Collection createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.createViewAction());
        actions.add(this.createHomeAction());
        return actions;
    }

    private URL getCurrentURL() {
        String value = this.getText();
        return URIUtilities.toURL(value, this.getProject().getProjectURI());
    }

    private void updateURLDisplay() {
        URL url = this.getCurrentURL();
        if (url == null) {
            this.clearUrlDisplay();
        } else {
            if (url.equals(this.urlDisplay.getPage())) {
                this.clearUrlDisplay();
            }
            this.setPage(url);
        }
    }

    private void setPage(URL url) {
        if (URLWidget.isImage(url)) {
            this.urlDisplay.setContentType("text/html");
            this.urlDisplay.setText("<HTML><BODY><IMG src=\"" + url + "\"></BODY></HTML>");
        } else {
            this.urlDisplay.setContentType("text/html");
            this.urlDisplay.setText("<HTML><BODY><H3>Loading...</H3></HTML>");
            this.asyncLoadURL(url);
        }
    }

    private void asyncLoadURL(final URL url) {
        Thread thread = new Thread(){

            public void run() {
                try {
                    URLWidget.this.getText(url);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                URLWidget.this.urlDisplay.setPage(url);
                            }
                            catch (IOException e) {
                                URLWidget.this.urlDisplay.setText("<HTML><BODY><H3>Cannot Find This Webpage</H3></HTML>");
                            }
                            catch (Throwable t) {
                                Log.getLogger().log(Level.INFO, "Exception caught", t);
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    Log.getLogger().log(Level.INFO, "Exception caught", t);
                }
            }
        };
        thread.start();
    }

    private String getText(URL url) {
        StringBuffer buffer = new StringBuffer();
        try {
            int nchars;
            char[] cbuf = new char[100000];
            InputStream is = url.openStream();
            InputStreamReader reader = new InputStreamReader(is);
            while ((nchars = reader.read(cbuf)) != -1) {
                buffer.append(cbuf, 0, nchars);
            }
        }
        catch (IOException e) {
            buffer.append("*** Load failed ***");
        }
        return buffer.toString();
    }

    private static boolean isImage(URL url) {
        String u = url.toString().toLowerCase();
        return u.endsWith(".gif") || u.endsWith(".png") || u.endsWith(".jpeg") || u.endsWith(".jpg");
    }

    private void clearUrlDisplay() {
        this.urlDisplay.setText(null);
        this.urlDisplay.getDocument().putProperty("stream", null);
    }

    protected void onSetText(String text) {
        this.updateURLDisplay();
    }
}

