/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.widget.TextFieldWidget;
import java.util.Collection;

public class UniqueStringWidget
extends TextFieldWidget {
    private static final long serialVersionUID = 2383411272010532217L;

    protected String getInvalidTextDescription(String text) {
        String invalidText = null;
        if (text == null || !this.isUnique(text)) {
            invalidText = "String is not unique";
        }
        return invalidText;
    }

    protected boolean isUnique(String text) {
        boolean isUnique;
        Collection frames = this.getKnowledgeBase().getFramesWithValue(this.getSlot(), null, false, text);
        switch (frames.size()) {
            case 0: {
                isUnique = true;
                break;
            }
            case 1: {
                Frame frame = (Frame)CollectionUtilities.getFirstItem(frames);
                isUnique = frame.equals(this.getInstance());
                break;
            }
            default: {
                isUnique = false;
            }
        }
        return isUnique;
    }
}

