/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.ValueTypeConstraint;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.ClsValuesComponent;
import edu.stanford.smi.protege.widget.InstanceValuesComponent;
import edu.stanford.smi.protege.widget.NullValuesComponent;
import edu.stanford.smi.protege.widget.SymbolValuesComponent;
import edu.stanford.smi.protege.widget.ValueTypeRenderer;
import edu.stanford.smi.protege.widget.ValuesComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class ValueTypeWidget
extends AbstractSlotWidget {
    private static final long serialVersionUID = 7319731533086348647L;
    private ValuesComponent _valuesComponent;
    private JComboBox _typeComboBox;
    private ValueType _oldValue;
    private boolean _isEditable;
    private ActionListener _typeListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            ValueType newValue = (ValueType)ValueTypeWidget.this._typeComboBox.getSelectedItem();
            if (newValue != ValueTypeWidget.this._oldValue) {
                if (this.confirmChange()) {
                    ValueTypeWidget.this.updateWidget();
                    ValueTypeWidget.this.valueChanged();
                    ValueTypeWidget.this._oldValue = newValue;
                } else {
                    ValueTypeWidget.this.setComboBoxValue(ValueTypeWidget.this._oldValue);
                }
            }
        }

        private boolean confirmChange() {
            boolean result = true;
            if (this.hasInstanceWithValue()) {
                ValueTypeWidget.this._typeComboBox.hidePopup();
                String text = "There may be instances which have values for this slot.\nChanging the type will cause these values to be removed.\n\nDo you really want to make this change?";
                int response = ModalDialog.showMessageDialog((Component)ValueTypeWidget.this, text, 13);
                result = response == 2;
            }
            return result;
        }

        private boolean hasInstanceWithValue() {
            Slot slot = (Slot)ValueTypeWidget.this.getInstance();
            return slot.hasValueAtSomeFrame();
        }
    };

    protected ComboBoxModel createModel() {
        ArrayList c = new ArrayList(ValueType.getValues());
        Collections.sort(c);
        return new DefaultComboBoxModel<Object>(c.toArray());
    }

    protected JComboBox getTypeComboBox() {
        return this._typeComboBox;
    }

    public Collection getSelection() {
        return this._valuesComponent.getSelection();
    }

    public Collection getValues() {
        Collection values = this._valuesComponent.getValues();
        if (values == null) {
            ValueType type = (ValueType)this._typeComboBox.getSelectedItem();
            values = ValueTypeConstraint.getValues(type);
        }
        return values;
    }

    public void initialize() {
        this._typeComboBox = ComponentFactory.createComboBox();
        this._typeComboBox.setModel(this.createModel());
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)new LabeledComponent(this.getLabel(), this._typeComboBox), "North");
        this._typeComboBox.addActionListener(this._typeListener);
        this.setValuesComponent(new NullValuesComponent());
        this._typeComboBox.setRenderer(new ValueTypeRenderer());
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return slot.getName().equals(":SLOT-VALUE-TYPE");
    }

    private void setComboBoxValue(ValueType type) {
        this._typeComboBox.removeActionListener(this._typeListener);
        this._typeComboBox.setSelectedItem(type);
        this.updateWidget();
        this._typeComboBox.addActionListener(this._typeListener);
        this._oldValue = type;
    }

    public void setEditable(boolean b) {
        this._isEditable = b;
        this._typeComboBox.setEnabled(b && this.canChangeType());
        this._valuesComponent.setEditable(b);
    }

    private boolean canChangeType() {
        return !this.isSlotAtCls() || this._typeComboBox.getSelectedItem().equals(ValueType.ANY);
    }

    public void setValues(Collection values) {
        if (values.isEmpty()) {
            Log.getLogger().warning("empty values: " + this.getInstance() + " " + this.getSlot());
            this.setComboBoxValue(ValueType.ANY);
        } else {
            ValueType type = ValueTypeConstraint.getType(values);
            this.setComboBoxValue(type);
            this._valuesComponent.setValues(values);
        }
    }

    private void setValuesComponent(ValuesComponent valueComponent) {
        if (this._valuesComponent != null) {
            this.remove(this._valuesComponent.getComponent());
            ComponentUtilities.dispose(this._valuesComponent.getComponent());
        }
        this._valuesComponent = valueComponent;
        this._valuesComponent.setEditable(this._isEditable);
        this.add(this._valuesComponent.getComponent());
        this.revalidate();
    }

    private void updateWidget() {
        ValueType type = (ValueType)this._typeComboBox.getSelectedItem();
        ValuesComponent valuesComponent = this.createValuesComponent(type);
        this.setValuesComponent(valuesComponent);
    }

    protected ValuesComponent createValuesComponent(ValueType type) {
        if (ValueTypeWidget.equals(type, ValueType.ANY)) {
            return new NullValuesComponent();
        }
        if (ValueTypeWidget.equals(type, ValueType.BOOLEAN)) {
            return new NullValuesComponent();
        }
        if (ValueTypeWidget.equals(type, ValueType.CLS)) {
            return new ClsValuesComponent(this.getProject());
        }
        if (ValueTypeWidget.equals(type, ValueType.FLOAT)) {
            return new NullValuesComponent();
        }
        if (ValueTypeWidget.equals(type, ValueType.INSTANCE)) {
            return new InstanceValuesComponent(this.getProject());
        }
        if (ValueTypeWidget.equals(type, ValueType.INTEGER)) {
            return new NullValuesComponent();
        }
        if (ValueTypeWidget.equals(type, ValueType.STRING)) {
            return new NullValuesComponent();
        }
        if (ValueTypeWidget.equals(type, ValueType.SYMBOL)) {
            return new SymbolValuesComponent();
        }
        Assert.fail("bad type: " + type);
        return null;
    }

    public String getLabel() {
        return this.localizeStandardLabel(super.getLabel(), "Value Type", ResourceKey.VALUE_TYPE_SLOT_WIDGET_LABEL);
    }
}

