/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.WidgetClassNameRenderer;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.widget.FormWidget;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;

class WidgetDescriptorEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = -7611162969958514326L;
    private FormWidget _widget;

    public WidgetDescriptorEditor(FormWidget widget) {
        super(ComponentFactory.createComboBox());
        this._widget = widget;
        this.getComboBox().setRenderer(new WidgetClassNameRenderer());
    }

    private JComboBox getComboBox() {
        return (JComboBox)this.getComponent();
    }

    private ComboBoxModel getComboBoxModel(Cls cls, Slot slot) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(WidgetClassNameRenderer.NONE);
        Project p = this._widget.getProject();
        Iterator i = p.getSuitableWidgetClassNames(cls, slot, null).iterator();
        while (i.hasNext()) {
            model.addElement((String)i.next());
        }
        return model;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JComboBox box = this.getComboBox();
        Slot slot = (Slot)table.getModel().getValueAt(row, 0);
        box.setModel(this.getComboBoxModel(this._widget.getCls(), slot));
        box.setSelectedItem(value);
        return this.getComponent();
    }
}

