/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DocumentChangedListener;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.TextComponentWidget;
import java.awt.Color;
import java.awt.Font;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;

public class YellowStickyWidget
extends AbstractSlotWidget {
    private static final long serialVersionUID = 1775374880544905639L;
    private static final Color YELLOW_STICKY_COLOR = new Color(255, 255, 204);
    private JTextArea _textArea;

    public Collection getValues() {
        String text = this._textArea.getText();
        Collection<Object> result = (text = text.trim()).length() == 0 ? Collections.EMPTY_LIST : CollectionUtilities.createCollection(text);
        return result;
    }

    public void addNotify() {
        super.addNotify();
        ComponentUtilities.requestFocus(this._textArea);
    }

    public void initialize() {
        this._textArea = ComponentFactory.createTextArea();
        this._textArea.setBackground(YELLOW_STICKY_COLOR);
        Font oldFont = this._textArea.getFont();
        Font newFont = new Font(oldFont.getName(), 2, oldFont.getSize());
        this._textArea.setFont(newFont);
        this._textArea.getDocument().addDocumentListener(new DocumentChangedListener(){

            public void stateChanged(ChangeEvent event) {
                YellowStickyWidget.this.valueChanged();
            }
        });
        JScrollPane pane = new JScrollPane(this._textArea);
        pane.setBorder(null);
        this.add(pane);
        this.setPreferredRows(2);
        this.setPreferredColumns(2);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return TextComponentWidget.isSuitable(cls, slot, facet);
    }

    public void setBorder(Border b) {
        if (this.isDesignTime()) {
            super.setBorder(b);
        }
    }

    public void setEditable(boolean editable) {
        this._textArea.setEnabled(editable);
    }

    public void setValues(Collection values) {
        String text = (String)CollectionUtilities.getFirstItem(values);
        if (text == null) {
            text = "";
        }
        this._textArea.setText(text);
    }
}

