/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owlapi.concurrent;

import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.protege.owlapi.concurrent.WriteSafeOWLOntology;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;

public class WriteSafeOWLOntologyImpl
implements OWLMutableOntology,
WriteSafeOWLOntology {
    private OWLMutableOntology delegate;
    private ReentrantReadWriteLock.ReadLock readLock;
    private ReentrantReadWriteLock.WriteLock writeLock;

    public WriteSafeOWLOntologyImpl(OWLMutableOntology delegate) {
        this.delegate = delegate;
    }

    @Override
    public void setLocks(ReentrantReadWriteLock locks) {
        this.readLock = locks.readLock();
        this.writeLock = locks.writeLock();
    }

    @Override
    public ReentrantReadWriteLock.ReadLock getReadLock() {
        return this.readLock;
    }

    @Override
    public ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.writeLock;
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OWLOntologyChange> applyChange(OWLOntologyChange change) throws OWLOntologyChangeException {
        this.writeLock.lock();
        try {
            List list = this.delegate.applyChange(change);
            return list;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OWLOntologyChange> applyChanges(List<OWLOntologyChange> changes) throws OWLOntologyChangeException {
        this.writeLock.lock();
        try {
            List list = this.delegate.applyChanges(changes);
            return list;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void accept(OWLObjectVisitor visitor) {
        this.delegate.accept(visitor);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)this.delegate.accept(visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compareTo(OWLObject o) {
        this.readLock.lock();
        try {
            int n = this.delegate.compareTo((Object)o);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAnnotationPropertyInSignature(IRI owlAnnotationPropertyIRI, boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAnnotationPropertyInSignature(owlAnnotationPropertyIRI, includeImportsClosure);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAnnotationPropertyInSignature(IRI owlAnnotationPropertyIRI) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAnnotationPropertyInSignature(owlAnnotationPropertyIRI);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAxiom(OWLAxiom axiom, boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAxiom(axiom, includeImportsClosure);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAxiom(OWLAxiom axiom) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAxiom(axiom);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAxiomIgnoreAnnotations(OWLAxiom axiom, boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAxiomIgnoreAnnotations(axiom, includeImportsClosure);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAxiomIgnoreAnnotations(OWLAxiom axiom) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAxiomIgnoreAnnotations(axiom);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsClassInSignature(IRI owlClassIRI, boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsClassInSignature(owlClassIRI, includeImportsClosure);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsClassInSignature(IRI owlClassIRI) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsClassInSignature(owlClassIRI);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDataPropertyInSignature(IRI owlDataPropertyIRI, boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsDataPropertyInSignature(owlDataPropertyIRI, includeImportsClosure);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDataPropertyInSignature(IRI owlDataPropertyIRI) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsDataPropertyInSignature(owlDataPropertyIRI);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDatatypeInSignature(IRI owlDatatypeIRI, boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsDatatypeInSignature(owlDatatypeIRI, includeImportsClosure);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDatatypeInSignature(IRI owlDatatypeIRI) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsDatatypeInSignature(owlDatatypeIRI);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEntityInSignature(IRI entityIRI, boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(entityIRI, includeImportsClosure);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEntityInSignature(IRI entityIRI) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(entityIRI);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEntityInSignature(OWLEntity owlEntity, boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(owlEntity, includeImportsClosure);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEntityInSignature(OWLEntity owlEntity) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(owlEntity);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsIndividualInSignature(IRI owlIndividualIRI, boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsIndividualInSignature(owlIndividualIRI, includeImportsClosure);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsIndividualInSignature(IRI owlIndividualIRI) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsIndividualInSignature(owlIndividualIRI);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsObjectPropertyInSignature(IRI owlObjectPropertyIRI, boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsObjectPropertyInSignature(owlObjectPropertyIRI, includeImportsClosure);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsObjectPropertyInSignature(IRI owlObjectPropertyIRI) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsObjectPropertyInSignature(owlObjectPropertyIRI);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLAnnotationSubject entity) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotationAssertionAxioms(entity);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotationPropertiesInSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAnnotationPropertyDomainAxiom> getAnnotationPropertyDomainAxioms(OWLAnnotationProperty property) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotationPropertyDomainAxioms(property);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAnnotationPropertyRangeAxiom> getAnnotationPropertyRangeAxioms(OWLAnnotationProperty property) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotationPropertyRangeAxioms(property);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAnnotation> getAnnotations() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotations();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnonymousIndividuals();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAsymmetricObjectPropertyAxiom> getAsymmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAsymmetricObjectPropertyAxioms(property);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAxiomCount() {
        this.readLock.lock();
        try {
            int n = this.delegate.getAxiomCount();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType, boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            int n = this.delegate.getAxiomCount(axiomType, includeImportsClosure);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType) {
        this.readLock.lock();
        try {
            int n = this.delegate.getAxiomCount(axiomType);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAxiom> getAxioms() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType, boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(axiomType, includeImportsClosure);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(axiomType);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty property) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(property);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLClassAxiom> getAxioms(OWLClass cls) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(cls);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty prop) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(prop);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype datatype) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(datatype);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual individual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(individual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression prop) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(prop);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom axiom, boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxiomsIgnoreAnnotations(axiom, includeImportsClosure);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom axiom) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxiomsIgnoreAnnotations(axiom);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLClassExpression ce) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getClassAssertionAxioms(ce);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLIndividual individual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getClassAssertionAxioms(individual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLClass> getClassesInSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getClassesInSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLClass> getClassesInSignature(boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getClassesInSignature(includeImportsClosure);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataPropertiesInSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDataProperty> getDataPropertiesInSignature(boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataPropertiesInSignature(includeImportsClosure);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDataPropertyAssertionAxiom> getDataPropertyAssertionAxioms(OWLIndividual individual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataPropertyAssertionAxioms(individual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDataPropertyDomainAxiom> getDataPropertyDomainAxioms(OWLDataProperty property) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataPropertyDomainAxioms(property);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDataPropertyRangeAxiom> getDataPropertyRangeAxioms(OWLDataProperty property) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataPropertyRangeAxioms(property);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSubProperty(OWLDataProperty subProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataSubPropertyAxiomsForSubProperty(subProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSuperProperty(OWLDataPropertyExpression superProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataSubPropertyAxiomsForSuperProperty(superProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDatatypeDefinitionAxiom> getDatatypeDefinitions(OWLDatatype datatype) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDatatypeDefinitions(datatype);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDatatype> getDatatypesInSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDatatypesInSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDatatype> getDatatypesInSignature(boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDatatypesInSignature(includeImportsClosure);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDeclarationAxiom> getDeclarationAxioms(OWLEntity subject) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDeclarationAxioms(subject);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDifferentIndividualsAxiom> getDifferentIndividualAxioms(OWLIndividual individual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDifferentIndividualAxioms(individual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLOntology> getDirectImports() throws UnknownOWLOntologyException {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDirectImports();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IRI> getDirectImportsDocuments() throws UnknownOWLOntologyException {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDirectImportsDocuments();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDisjointClassesAxiom> getDisjointClassesAxioms(OWLClass cls) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDisjointClassesAxioms(cls);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDisjointDataPropertiesAxiom> getDisjointDataPropertiesAxioms(OWLDataProperty property) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDisjointDataPropertiesAxioms(property);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDisjointObjectPropertiesAxiom> getDisjointObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDisjointObjectPropertiesAxioms(property);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDisjointUnionAxiom> getDisjointUnionAxioms(OWLClass owlClass) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDisjointUnionAxioms(owlClass);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLEntity> getEntitiesInSignature(IRI iri, boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getEntitiesInSignature(iri, includeImportsClosure);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLEntity> getEntitiesInSignature(IRI iri) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getEntitiesInSignature(iri);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLEquivalentClassesAxiom> getEquivalentClassesAxioms(OWLClass cls) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getEquivalentClassesAxioms(cls);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLEquivalentDataPropertiesAxiom> getEquivalentDataPropertiesAxioms(OWLDataProperty property) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getEquivalentDataPropertiesAxioms(property);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLEquivalentObjectPropertiesAxiom> getEquivalentObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getEquivalentObjectPropertiesAxioms(property);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLFunctionalDataPropertyAxiom> getFunctionalDataPropertyAxioms(OWLDataPropertyExpression property) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getFunctionalDataPropertyAxioms(property);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLFunctionalObjectPropertyAxiom> getFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getFunctionalObjectPropertyAxioms(property);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLClassAxiom> getGeneralClassAxioms() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getGeneralClassAxioms();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLHasKeyAxiom> getHasKeyAxioms(OWLClass cls) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getHasKeyAxioms(cls);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLOntology> getImports() throws UnknownOWLOntologyException {
        this.readLock.lock();
        try {
            Set set = this.delegate.getImports();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLOntology> getImportsClosure() throws UnknownOWLOntologyException {
        this.readLock.lock();
        try {
            Set set = this.delegate.getImportsClosure();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLImportsDeclaration> getImportsDeclarations() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getImportsDeclarations();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getIndividualsInSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLNamedIndividual> getIndividualsInSignature(boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getIndividualsInSignature(includeImportsClosure);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLInverseFunctionalObjectPropertyAxiom> getInverseFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getInverseFunctionalObjectPropertyAxioms(property);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLInverseObjectPropertiesAxiom> getInverseObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getInverseObjectPropertyAxioms(property);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLIrreflexiveObjectPropertyAxiom> getIrreflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getIrreflexiveObjectPropertyAxioms(property);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLogicalAxiomCount() {
        this.readLock.lock();
        try {
            int n = this.delegate.getLogicalAxiomCount();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLLogicalAxiom> getLogicalAxioms() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getLogicalAxioms();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLNegativeDataPropertyAssertionAxiom> getNegativeDataPropertyAssertionAxioms(OWLIndividual individual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getNegativeDataPropertyAssertionAxioms(individual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLNegativeObjectPropertyAssertionAxiom> getNegativeObjectPropertyAssertionAxioms(OWLIndividual individual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getNegativeObjectPropertyAssertionAxioms(individual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLClassExpression> getNestedClassExpressions() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getNestedClassExpressions();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectPropertiesInSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLObjectProperty> getObjectPropertiesInSignature(boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectPropertiesInSignature(includeImportsClosure);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLObjectPropertyAssertionAxiom> getObjectPropertyAssertionAxioms(OWLIndividual individual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectPropertyAssertionAxioms(individual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLObjectPropertyDomainAxiom> getObjectPropertyDomainAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectPropertyDomainAxioms(property);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLObjectPropertyRangeAxiom> getObjectPropertyRangeAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectPropertyRangeAxioms(property);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSubProperty(OWLObjectPropertyExpression subProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectSubPropertyAxiomsForSubProperty(subProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSuperProperty(OWLObjectPropertyExpression superProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectSubPropertyAxiomsForSuperProperty(superProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWLOntologyID getOntologyID() {
        this.readLock.lock();
        try {
            OWLOntologyID oWLOntologyID = this.delegate.getOntologyID();
            return oWLOntologyID;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWLOntologyManager getOWLOntologyManager() {
        this.readLock.lock();
        try {
            OWLOntologyManager oWLOntologyManager = this.delegate.getOWLOntologyManager();
            return oWLOntologyManager;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getReferencedAnonymousIndividuals();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAxiom> getReferencingAxioms(OWLAnonymousIndividual individual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getReferencingAxioms(individual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAxiom> getReferencingAxioms(OWLEntity owlEntity, boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getReferencingAxioms(owlEntity, includeImportsClosure);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAxiom> getReferencingAxioms(OWLEntity owlEntity) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getReferencingAxioms(owlEntity);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLReflexiveObjectPropertyAxiom> getReflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getReflexiveObjectPropertyAxioms(property);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLSameIndividualAxiom> getSameIndividualAxioms(OWLIndividual individual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSameIndividualAxioms(individual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLEntity> getSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLEntity> getSignature(boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSignature(includeImportsClosure);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLSubAnnotationPropertyOfAxiom> getSubAnnotationPropertyOfAxioms(OWLAnnotationProperty subProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSubAnnotationPropertyOfAxioms(subProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSubClass(OWLClass cls) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSubClassAxiomsForSubClass(cls);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSuperClass(OWLClass cls) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSubClassAxiomsForSuperClass(cls);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLSymmetricObjectPropertyAxiom> getSymmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSymmetricObjectPropertyAxioms(property);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLTransitiveObjectPropertyAxiom> getTransitiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getTransitiveObjectPropertyAxioms(property);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAnonymous() {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isAnonymous();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBottomEntity() {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isBottomEntity();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeclared(OWLEntity owlEntity, boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isDeclared(owlEntity, includeImportsClosure);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeclared(OWLEntity owlEntity) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isDeclared(owlEntity);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTopEntity() {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isTopEntity();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAxiom> getABoxAxioms(boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getABoxAxioms(includeImportsClosure);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAxiom> getRBoxAxioms(boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getRBoxAxioms(includeImportsClosure);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAxiom> getTBoxAxioms(boolean includeImportsClosure) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getTBoxAxioms(includeImportsClosure);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

