/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owlapi.inconsistent;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.protege.owlapi.inconsistent.TypeCollector;
import org.protege.owlapi.inconsistent.Util;
import org.protege.owlapi.inconsistent.trivialModel.AxiomInterpreter;
import org.protege.owlapi.inconsistent.trivialModel.TrivialModel;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.FileDocumentTarget;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.io.OWLXMLOntologyFormat;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class OntologySplitter {
    private OWLOntology originalOntology;
    private OWLOntology consistentPart;
    private OWLOntology otherPart;
    private OWLOntology surrogateTypePart;
    private OWLOntology hotSpotPart;
    private TypeCollector typeCollector;
    private Map<OWLAxiom, OWLAxiom> substituteAxiomMap = new HashMap<OWLAxiom, OWLAxiom>();

    public OWLOntology getConsistentPart() {
        return this.consistentPart;
    }

    public OWLOntology getOtherPart() {
        return this.otherPart;
    }

    public TypeCollector getTypeCollector() {
        return this.typeCollector;
    }

    public OWLOntology getSurrogateTypePart() {
        return this.surrogateTypePart;
    }

    public OWLOntology getHotSpotPart() {
        return this.hotSpotPart;
    }

    public OWLAxiom getOriginalAxiom(OWLAxiom substituteAxiom) {
        return this.substituteAxiomMap.get(substituteAxiom);
    }

    public void split(OWLOntology ontology, OWLReasonerFactory reasonerFactory) throws OWLOntologyCreationException {
        this.originalOntology = ontology;
        this.typeCollector = new TypeCollector(ontology.getOWLOntologyManager().getOWLDataFactory());
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        this.initializeOntologies(manager);
        this.assignAxioms(ontology, reasonerFactory);
    }

    private void initializeOntologies(OWLOntologyManager manager) throws OWLOntologyCreationException {
        IRI consistentPartIRI = Util.generateRandomIRI("ConsistentSubset");
        this.consistentPart = manager.createOntology(consistentPartIRI);
        this.otherPart = manager.createOntology(Util.generateRandomIRI("RemainingAxioms"));
        this.surrogateTypePart = manager.createOntology(Util.generateRandomIRI("SurrogateIndividualTypes"));
        this.hotSpotPart = manager.createOntology(Util.generateRandomIRI("Hotspots"));
        OWLImportsDeclaration decl = manager.getOWLDataFactory().getOWLImportsDeclaration(consistentPartIRI);
        manager.applyChange((OWLOntologyChange)new AddImport(this.otherPart, decl));
        manager.applyChange((OWLOntologyChange)new AddImport(this.surrogateTypePart, decl));
        manager.applyChange((OWLOntologyChange)new AddImport(this.hotSpotPart, decl));
    }

    private void assignAxioms(OWLOntology originalOntology, OWLReasonerFactory reasonerFactory) throws OWLOntologyCreationException {
        AxiomInterpreter interpreter = new AxiomInterpreter(new TrivialModel(originalOntology, reasonerFactory));
        OWLOntologyManager manager = this.consistentPart.getOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLOntology inClosure : originalOntology.getImportsClosure()) {
            for (OWLAxiom axiom : inClosure.getAxioms()) {
                if (((Boolean)axiom.accept((OWLAxiomVisitorEx)interpreter)).booleanValue()) {
                    changes.add(new AddAxiom(this.consistentPart, axiom));
                    continue;
                }
                OWLAxiom substituteAxiom = (OWLAxiom)axiom.accept((OWLAxiomVisitorEx)this.typeCollector);
                if (substituteAxiom != null) {
                    changes.add(new AddAxiom(this.surrogateTypePart, substituteAxiom));
                    this.substituteAxiomMap.put(substituteAxiom, axiom);
                } else {
                    changes.add(new AddAxiom(this.hotSpotPart, axiom));
                }
                changes.add(new AddAxiom(this.otherPart, axiom));
            }
        }
        manager.applyChanges(changes);
        changes.clear();
        for (OWLAxiom axiom : this.typeCollector.getSingletonAxioms()) {
            changes.add(new AddAxiom(this.surrogateTypePart, axiom));
        }
        manager.applyChanges(changes);
        changes.clear();
        for (OWLEntity e : this.otherPart.getSignature()) {
            if (this.consistentPart.containsEntityInSignature(e)) continue;
            changes.add(new AddAxiom(this.consistentPart, (OWLAxiom)factory.getOWLDeclarationAxiom(e)));
        }
        manager.applyChanges(changes);
    }

    public File saveOntologies(File parent) throws OWLOntologyStorageException {
        File dir;
        OWLOntologyManager manager = this.consistentPart.getOWLOntologyManager();
        int i = 0;
        while ((dir = new File(parent, "explanation-" + i)).exists()) {
            ++i;
        }
        dir.mkdir();
        OWLXMLOntologyFormat format = new OWLXMLOntologyFormat();
        OWLOntologyFormat originalFormat = this.originalOntology.getOWLOntologyManager().getOntologyFormat(this.originalOntology);
        if (originalFormat.isPrefixOWLOntologyFormat()) {
            format.copyPrefixesFrom(originalFormat.asPrefixOWLOntologyFormat());
        }
        manager.saveOntology(this.consistentPart, (OWLOntologyFormat)format, (OWLOntologyDocumentTarget)new FileDocumentTarget(new File(dir, "ConsistentSubset.owl")));
        manager.saveOntology(this.surrogateTypePart, (OWLOntologyFormat)format, (OWLOntologyDocumentTarget)new FileDocumentTarget(new File(dir, "SurrogateTypes.owl")));
        manager.saveOntology(this.otherPart, (OWLOntologyFormat)format, (OWLOntologyDocumentTarget)new FileDocumentTarget(new File(dir, "RemainingPart.owl")));
        return dir;
    }
}

