/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owlapi.inconsistent.trivialModel;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.protege.owlapi.inconsistent.trivialModel.TrivialModel;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;

public class ClassExpressionInterpreter
implements OWLClassExpressionVisitorEx<Set<OWLIndividual>> {
    private TrivialModel model;

    public ClassExpressionInterpreter(TrivialModel model) {
        this.model = model;
    }

    public Set<OWLIndividual> visit(OWLClass ce) {
        if (this.model.isTopClass(ce)) {
            return this.model.getAllIndividuals();
        }
        return Collections.emptySet();
    }

    public Set<OWLIndividual> visit(OWLObjectIntersectionOf ce) {
        Set<OWLIndividual> interpretation = null;
        for (OWLClassExpression conjunct : ce.getOperands()) {
            if (interpretation == null) {
                interpretation = new TreeSet<OWLIndividual>((Collection)conjunct.accept((OWLClassExpressionVisitorEx)this));
                continue;
            }
            interpretation.removeAll((Collection)conjunct.accept((OWLClassExpressionVisitorEx)this));
        }
        if (interpretation == null) {
            interpretation = this.model.getAllIndividuals();
        }
        return interpretation;
    }

    public Set<OWLIndividual> visit(OWLObjectUnionOf ce) {
        TreeSet<OWLIndividual> interpretation = new TreeSet<OWLIndividual>();
        for (OWLClassExpression conjunct : ce.getOperands()) {
            interpretation.addAll((Collection)conjunct.accept((OWLClassExpressionVisitorEx)this));
        }
        return interpretation;
    }

    public Set<OWLIndividual> visit(OWLObjectComplementOf ce) {
        TreeSet<OWLIndividual> interpretation = new TreeSet<OWLIndividual>(this.model.getAllIndividuals());
        interpretation.removeAll((Collection)ce.getOperand().accept((OWLClassExpressionVisitorEx)this));
        return interpretation;
    }

    public Set<OWLIndividual> visit(OWLObjectSomeValuesFrom ce) {
        if (this.model.isTopProperty((OWLObjectPropertyExpression)ce.getProperty())) {
            Set interpretation = (Set)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this);
            if (interpretation.isEmpty()) {
                return Collections.emptySet();
            }
            return this.model.getAllIndividuals();
        }
        return Collections.emptySet();
    }

    public Set<OWLIndividual> visit(OWLObjectAllValuesFrom ce) {
        if (this.model.isTopProperty((OWLObjectPropertyExpression)ce.getProperty())) {
            Set interpretation = (Set)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this);
            if (((Object)interpretation).equals(this.model.getAllIndividuals())) {
                return this.model.getAllIndividuals();
            }
            return Collections.emptySet();
        }
        return this.model.getAllIndividuals();
    }

    public Set<OWLIndividual> visit(OWLObjectHasValue ce) {
        if (this.model.isTopProperty((OWLObjectPropertyExpression)ce.getProperty())) {
            return this.model.getAllIndividuals();
        }
        return Collections.emptySet();
    }

    public Set<OWLIndividual> visit(OWLObjectMinCardinality ce) {
        if (this.model.isTopProperty((OWLObjectPropertyExpression)ce.getProperty()) && ((Set)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this)).size() >= ce.getCardinality()) {
            return this.model.getAllIndividuals();
        }
        if (ce.getCardinality() == 0) {
            return this.model.getAllIndividuals();
        }
        return Collections.emptySet();
    }

    public Set<OWLIndividual> visit(OWLObjectExactCardinality ce) {
        if (this.model.isTopProperty((OWLObjectPropertyExpression)ce.getProperty()) && ce.getCardinality() == ((Set)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this)).size()) {
            return this.model.getAllIndividuals();
        }
        return Collections.emptySet();
    }

    public Set<OWLIndividual> visit(OWLObjectMaxCardinality ce) {
        if (this.model.isTopProperty((OWLObjectPropertyExpression)ce.getProperty()) && ((Set)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this)).size() > ce.getCardinality()) {
            return Collections.emptySet();
        }
        return this.model.getAllIndividuals();
    }

    public Set<OWLIndividual> visit(OWLObjectHasSelf ce) {
        if (this.model.isTopProperty((OWLObjectPropertyExpression)ce.getProperty())) {
            return this.model.getAllIndividuals();
        }
        return Collections.emptySet();
    }

    public Set<OWLIndividual> visit(OWLObjectOneOf ce) {
        return new TreeSet<OWLIndividual>(ce.getIndividuals());
    }

    public Set<OWLIndividual> visit(OWLDataSomeValuesFrom ce) {
        if (this.model.isTopProperty((OWLDataPropertyExpression)ce.getProperty()) && this.model.isConsistent((OWLDataRange)ce.getFiller())) {
            return this.model.getAllIndividuals();
        }
        return Collections.emptySet();
    }

    public Set<OWLIndividual> visit(OWLDataAllValuesFrom ce) {
        if (this.model.isTopProperty((OWLDataPropertyExpression)ce.getProperty()) && this.model.isTopDataRange((OWLDataRange)ce.getFiller())) {
            return this.model.getAllIndividuals();
        }
        if (this.model.isTopProperty((OWLDataPropertyExpression)ce.getProperty())) {
            return Collections.emptySet();
        }
        return this.model.getAllIndividuals();
    }

    public Set<OWLIndividual> visit(OWLDataHasValue ce) {
        if (this.model.isTopProperty((OWLDataPropertyExpression)ce.getProperty())) {
            return this.model.getAllIndividuals();
        }
        return Collections.emptySet();
    }

    public Set<OWLIndividual> visit(OWLDataMinCardinality ce) {
        if (this.model.isTopProperty((OWLDataPropertyExpression)ce.getProperty()) && this.model.hasAtLeast((OWLDataRange)ce.getFiller(), ce.getCardinality())) {
            return this.model.getAllIndividuals();
        }
        if (!this.model.isTopProperty((OWLDataPropertyExpression)ce.getProperty()) && ce.getCardinality() == 0) {
            return this.model.getAllIndividuals();
        }
        return Collections.emptySet();
    }

    public Set<OWLIndividual> visit(OWLDataExactCardinality ce) {
        if (this.model.isTopProperty((OWLDataPropertyExpression)ce.getProperty()) && this.model.hasExactly((OWLDataRange)ce.getFiller(), ce.getCardinality())) {
            return this.model.getAllIndividuals();
        }
        if (!this.model.isTopProperty((OWLDataPropertyExpression)ce.getProperty()) && ce.getCardinality() == 0) {
            return this.model.getAllIndividuals();
        }
        return Collections.emptySet();
    }

    public Set<OWLIndividual> visit(OWLDataMaxCardinality ce) {
        if (this.model.isTopProperty((OWLDataPropertyExpression)ce.getProperty()) && this.model.hasNoMoreThan((OWLDataRange)ce.getFiller(), ce.getCardinality())) {
            return this.model.getAllIndividuals();
        }
        return this.model.getAllIndividuals();
    }
}

