/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owlapi.inference.cls;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.protege.owlapi.inference.cls.ChildClassExtractor;
import org.protege.owlapi.inference.cls.NamedClassExtractor;
import org.protege.owlapi.inference.orphan.Relation;
import org.protege.owlapi.inference.orphan.TerminalElementFinder;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;

public class ClassHierarchyReasoner {
    private OWLOntologyManager owlOntologyManager;
    private Set<OWLOntology> ontologies;
    private OWLClass root;
    private NamedClassExtractor namedClassExtractor;
    private ChildClassExtractor childClassExtractor;
    private OWLOntologyChangeListener listener;
    private TerminalElementFinder<OWLClass> rootFinder;

    public ClassHierarchyReasoner(OWLOntologyManager manager, Set<OWLOntology> ontologies) {
        this.owlOntologyManager = manager;
        OWLDataFactory factory = manager.getOWLDataFactory();
        this.root = factory.getOWLThing();
        ontologies = new HashSet<OWLOntology>();
        this.rootFinder = new TerminalElementFinder<OWLClass>(new Relation<OWLClass>(){

            @Override
            public Collection<OWLClass> getR(OWLClass cls) {
                Set parents = ClassHierarchyReasoner.this.getSuperClasses((OWLClassExpression)cls, true).getFlattened();
                parents.remove(ClassHierarchyReasoner.this.root);
                return parents;
            }
        });
        this.namedClassExtractor = new NamedClassExtractor();
        this.childClassExtractor = new ChildClassExtractor();
        this.listener = new OWLOntologyChangeListener(){

            public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
                ClassHierarchyReasoner.this.handleChanges(changes);
            }
        };
        this.owlOntologyManager.addOntologyChangeListener(this.listener);
    }

    private void handleChanges(List<? extends OWLOntologyChange> changes) {
        HashSet<OWLClass> possibleTerminalElements = new HashSet<OWLClass>();
        HashSet<OWLClass> notInOntologies = new HashSet<OWLClass>();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!this.ontologies.contains(oWLOntologyChange.getOntology()) || !oWLOntologyChange.isAxiomChange()) continue;
            boolean remove = oWLOntologyChange instanceof RemoveAxiom;
            OWLAxiom axiom = oWLOntologyChange.getAxiom();
            for (OWLEntity entity : axiom.getSignature()) {
                if (!(entity instanceof OWLClass) || entity.equals(this.root)) continue;
                OWLClass cls = (OWLClass)entity;
                if (remove && !this.containsReference(cls)) {
                    notInOntologies.add(cls);
                    continue;
                }
                if (!remove) {
                    notInOntologies.remove(cls);
                }
                possibleTerminalElements.add(cls);
            }
        }
        possibleTerminalElements.addAll(this.rootFinder.getTerminalElements());
        possibleTerminalElements.removeAll(notInOntologies);
        this.rootFinder.findTerminalElements(possibleTerminalElements);
    }

    private boolean containsReference(OWLClass object) {
        for (OWLOntology ont : this.ontologies) {
            if (!ont.containsClassInSignature(object.getIRI())) continue;
            return true;
        }
        return false;
    }

    public void preComputeInferences() {
        this.rootFinder.clear();
        for (OWLOntology ont : this.ontologies) {
            Set ref = ont.getClassesInSignature();
            this.rootFinder.appendTerminalElements(ref);
        }
        this.rootFinder.finish();
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (ce.isAnonymous()) {
            return new OWLClassNodeSet(this.owlOntologyManager.getOWLDataFactory().getOWLThing());
        }
        OWLClass cls = ce.asOWLClass();
        TreeSet<OWLClass> parents = new TreeSet<OWLClass>();
        this.namedClassExtractor.reset();
        for (OWLClassExpression superClassExpression : cls.getSuperClasses(this.ontologies)) {
            superClassExpression.accept((OWLClassExpressionVisitor)this.namedClassExtractor);
        }
        for (OWLClassExpression equivalentClassExpression : cls.getEquivalentClasses(this.ontologies)) {
            if (!equivalentClassExpression.isAnonymous()) continue;
            equivalentClassExpression.accept((OWLClassExpressionVisitor)this.namedClassExtractor);
        }
        parents.addAll(this.namedClassExtractor.getResult());
        throw new UnsupportedOperationException("How should I do this?  Is OWLReasoner the best interface?");
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression ce, boolean direct) {
        return null;
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression ce) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return null;
    }

    public void dispose() {
        this.owlOntologyManager.removeOntologyChangeListener(this.listener);
    }
}

