/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owlapi.inference.orphan;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class EquivalenceRelation<X extends Comparable<? super X>> {
    private Map<X, Set<X>> equivalenceMap = new HashMap<X, Set<X>>();

    public boolean equivalent(X x, X y) {
        Set<X> equivalentToX = this.equivalenceMap.get(x);
        return x.equals(y) || equivalentToX != null && equivalentToX.contains(y);
    }

    public void merge(Collection<X> toBeMerged) {
        if (toBeMerged.size() <= 1) {
            return;
        }
        TreeSet<Comparable> equivalenceClass = new TreeSet<Comparable>();
        for (Comparable x : toBeMerged) {
            Set existingEquivalences = this.equivalenceMap.put(x, equivalenceClass);
            if (existingEquivalences != null) {
                equivalenceClass.addAll(existingEquivalences);
                continue;
            }
            equivalenceClass.add(x);
        }
    }

    public Set<X> getEquivalenceClass(X x) {
        Set<X> equivalents = this.equivalenceMap.get(x);
        return equivalents != null ? new TreeSet<X>(equivalents) : Collections.singleton(x);
    }

    public void logEquivalences(Logger log, Level level) {
        if (log.isEnabledFor((Priority)level)) {
            log.log((Priority)level, (Object)"---------------Logging equivalences---------------");
            HashSet<X> displayed = new HashSet<X>();
            for (Map.Entry<X, Set<X>> entry : this.equivalenceMap.entrySet()) {
                Comparable x = (Comparable)entry.getKey();
                Set<X> equivalences = entry.getValue();
                if (displayed.contains(x)) continue;
                log.log((Priority)level, (Object)("The following are equivalent: " + equivalences));
                displayed.addAll(equivalences);
            }
            log.log((Priority)level, (Object)"---------------Equivalences Logged---------------");
        }
    }

    public void clear() {
        this.equivalenceMap.clear();
    }
}

