/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.pkcs;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.InvalidCertRequestException;
import edu.uiuc.ncsa.security.util.pkcs.MyPKCS10CertRequest;
import edu.uiuc.ncsa.security.util.pkcs.PEMFormatUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;
import sun.security.pkcs.PKCS10;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.X500Name;

public class CertUtil {
    public static final String UTF_8 = "UTF-8";
    static Logger logger;
    public static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    public static final String DEFAULT_PKCS10_SIGNATURE_ALGORITHM = "SHA1withRSA";
    public static final String DEFAULT_PKCS10_PROVIDER = "SunRsaSign";
    public static final String DEFAULT_PKCS10_DISTINGUISHED_NAME = "CN=ignore";
    static CertificateFactory certFactory;

    public static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger(CertUtil.class.getName());
        }
        return logger;
    }

    public static X509Certificate[] getX509CertsFromStringList(String[] certList, String[] nameList) throws CertificateException {
        ArrayList<X509Certificate> c = new ArrayList<X509Certificate>(certList.length);
        for (int i = 0; i < certList.length; ++i) {
            int index = -1;
            String certData = certList[i];
            if (certData != null) {
                index = certData.indexOf(BEGIN_CERTIFICATE);
            }
            if (index < 0) continue;
            certData = certData.substring(index);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(certData.getBytes());
            try {
                X509Certificate cert = (X509Certificate)CertUtil.getCertFactory().generateCertificate(inputStream);
                c.add(cert);
                continue;
            }
            catch (Exception e) {
                if (nameList != null) {
                    CertUtil.getLogger().warning(nameList[i] + " can not be parsed as an X509Certificate.");
                    continue;
                }
                CertUtil.getLogger().warning("failed to parse an X509Certificate");
            }
        }
        if (c.isEmpty()) {
            return null;
        }
        return c.toArray(new X509Certificate[0]);
    }

    public static void toPEM(X509Certificate x509Certificate, OutputStream outputStream) throws CertificateEncodingException {
        PEMFormatUtil.delimitBody(x509Certificate.getEncoded(), BEGIN_CERTIFICATE, END_CERTIFICATE, outputStream);
    }

    public static MyPKCS10CertRequest fromStringToCertReq(String x) {
        return new MySunPKCS_CR(Base64.decodeBase64((String)x));
    }

    public static String fromCertReqToString(MyPKCS10CertRequest certReq) {
        if (certReq == null) {
            return null;
        }
        return Base64.encodeBase64String((byte[])certReq.getEncoded());
    }

    public static X509Certificate[] fromX509PEM(String certString) throws CertificateException {
        try {
            ByteArrayInputStream bs = new ByteArrayInputStream(certString.getBytes(UTF_8));
            return CertUtil.fromPEM(bs);
        }
        catch (Exception e) {
            throw new GeneralException("Error converting cert string", (Throwable)e);
        }
    }

    public static X509Certificate[] fromPEM(InputStream inputStream) throws CertificateException {
        return CertUtil.getCertFactory().generateCertificates(inputStream).toArray(new X509Certificate[0]);
    }

    public static CertificateFactory getCertFactory() throws CertificateException {
        if (certFactory == null) {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        return certFactory;
    }

    public static String toPEM(X509Certificate x509Certificate) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CertUtil.toPEM(x509Certificate, (OutputStream)baos);
            return new String(baos.toByteArray(), UTF_8);
        }
        catch (Exception e) {
            throw new GeneralException("Error encoding cert", (Throwable)e);
        }
    }

    public static void toPEM(Collection<X509Certificate> x509Certificates, OutputStream out) {
        X509Certificate[] certs = new X509Certificate[x509Certificates.size()];
        certs = x509Certificates.toArray(certs);
        CertUtil.toPEM(certs, out);
    }

    public static String toPEM(Collection<X509Certificate> x509Certificates) {
        X509Certificate[] certs = new X509Certificate[x509Certificates.size()];
        certs = x509Certificates.toArray(certs);
        return CertUtil.toPEM(certs);
    }

    public static void toPEM(X509Certificate[] x509Certificates, OutputStream out) {
        PrintStream printStream = new PrintStream(out);
        printStream.print(CertUtil.toPEM(x509Certificates));
        printStream.flush();
    }

    public static String toPEM(X509Certificate[] x509Certificates) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean firstPass = true;
        for (X509Certificate x509Certificate : x509Certificates) {
            if (firstPass) {
                stringBuffer.append(CertUtil.toPEM(x509Certificate));
                firstPass = false;
                continue;
            }
            stringBuffer.append("\n" + CertUtil.toPEM(x509Certificate));
        }
        return stringBuffer.toString();
    }

    public static MyPKCS10CertRequest createCertRequest(KeyPair keypair) throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, IOException {
        return CertUtil.createCertRequest(keypair, DEFAULT_PKCS10_SIGNATURE_ALGORITHM, DEFAULT_PKCS10_PROVIDER, DEFAULT_PKCS10_DISTINGUISHED_NAME);
    }

    public static MyPKCS10CertRequest createCertRequest(KeyPair keypair, String sigAlgName, String dn, String provider) throws SignatureException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, IOException {
        PKCS10 pkcs10 = new PKCS10(keypair.getPublic());
        Signature signature = Signature.getInstance(sigAlgName);
        signature.initSign(keypair.getPrivate());
        try {
            X500Name x500Name = null;
            x500Name = dn == null ? new X500Name("ignore", "OU", "OU", "USA") : new X500Name("ignore", "OU", "OU", "USA");
            pkcs10.encodeAndSign(x500Name, signature);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bs);
            pkcs10.print(ps);
            byte[] c = bs.toByteArray();
            if (ps != null) {
                ps.close();
            }
            if (bs != null) {
                bs.close();
            }
        }
        catch (RuntimeException rx) {
            throw rx;
        }
        catch (Throwable th) {
            throw new GeneralException("Error creating cert request", th);
        }
        return new MySunPKCS_CR(pkcs10);
    }

    public static String getDN(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectDN().getName();
    }

    public static String getEPPN(X509Certificate x509Certificate) {
        byte[] rawEPPN = x509Certificate.getExtensionValue("1.3.6.1.4.1.5923.1.1.1.6");
        String eppn = null;
        if (rawEPPN != null) {
            eppn = new String(rawEPPN).substring(4);
        }
        return eppn;
    }

    public static String getEmail(X509Certificate x509Certificate) {
        Collection<List<?>> collection = null;
        try {
            collection = x509Certificate.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException e) {
            throw new GeneralException("Error parsing cert", (Throwable)e);
        }
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        String email = null;
        for (List<?> object : collection) {
            email = object.get(1).toString();
        }
        return email;
    }

    public static class MySunPKCS_CR
    extends MyPKCS10CertRequest {
        PKCS10 pkcs10;

        public MySunPKCS_CR(byte[] derEncoded) {
            try {
                this.checkVersion(derEncoded);
                this.pkcs10 = new PKCS10(derEncoded);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InvalidCertRequestException("Error creating cert request from byte array", (Throwable)e);
            }
        }

        protected void checkVersion(byte[] derEncoded) {
            try {
                DerInputStream derInputStream = new DerInputStream(derEncoded);
                DerValue[] seq = derInputStream.getSequence(3);
                seq[0].data.getBigInteger();
            }
            catch (IOException iox) {
                throw new InvalidCertRequestException("Invalid Certification Request. Be sure that the version number of the (PCKS10) request is set to zero.", (Throwable)iox);
            }
        }

        public String toString() {
            if (this.pkcs10 == null) {
                return "null";
            }
            return this.pkcs10.toString();
        }

        public MySunPKCS_CR(PKCS10 pkcs10) {
            this.pkcs10 = pkcs10;
        }

        @Override
        public PublicKey getPublicKey() {
            return this.pkcs10.getSubjectPublicKeyInfo();
        }

        @Override
        public byte[] getEncoded() {
            return this.pkcs10.getEncoded();
        }
    }
}

