/*
 * Copyright 2014 CITIUS <http://citius.usc.es>, University of Santiago de Compostela.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package es.usc.citius.hipster.model;

import java.util.List;

/**
 * A node encapsulates the information generated by the search algorithms during their execution. As different
 * type of algorithms exist (uninformed, informed, heuristic, anytime, etc.), different type of nodes
 * are required. This interface provide the skeleton for the node definition and the basic methods required
 * by all type of nodes.
 *
 * @param <A> type of the actions
 * @param <S> type of the state
 * @param <N> node type
 *
 * @author Pablo Rodríguez Mier <<a href="mailto:pablo.rodriguez.mier@usc.es">pablo.rodriguez.mier@usc.es</a>>
 * @author Adrián González Sieira <<a href="adrian.gonzalez@usc.es">adrian.gonzalez@usc.es</a>>
 */
public interface Node<A,S,N extends Node<A,S,N>> {

    /**
     * Generates the ordered list of nodes with the path between the beginning state
     * and the current node.
     *
     * @return ordered List the nodes of the path
     */
    List<N> path();

    /**
     * Returns the length of the path from the start to the current node. Note that pathSize() == path().size()
     * but this method provides a fast way to obtain the length of the path without tracking back the nodes of the path.
     * @return length of the path from the initial node to this node.
     */
    int pathSize();

    /**
     * Returns the previous node to the current.
     *
     * @return instance of {@link es.usc.citius.hipster.model.Node}
     */
    N previousNode();

    /**
     * State of the current node
     * @return
     */
    S state();

    /**
     * Action of the node used to reach the state node
     * @return
     */
    A action();

}
