/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.algorithm;

import es.usc.citius.hipster.algorithm.Algorithm;
import es.usc.citius.hipster.model.ADStarNode;
import es.usc.citius.hipster.model.Transition;
import es.usc.citius.hipster.model.function.impl.ADStarNodeExpander;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;

public class ADStarForward<A, S, C extends Comparable<C>, N extends ADStarNode<A, S, C, N>>
extends Algorithm<A, S, N> {
    protected S begin;
    protected Collection<S> goals;
    protected ADStarNodeExpander<A, S, C, N> expander;

    public ADStarForward(S begin, S goal, ADStarNodeExpander<A, S, C, N> expander) {
        this(begin, (Collection<S>)Collections.singleton(goal), expander);
    }

    public ADStarForward(S begin, Collection<S> goals, ADStarNodeExpander<A, S, C, N> expander) {
        this.begin = begin;
        this.goals = goals;
        this.expander = expander;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public class Iterator
    implements java.util.Iterator<N> {
        protected Map<S, N> open;
        protected Map<S, N> closed;
        protected Map<S, N> incons;
        protected Iterable<Transition<A, S>> transitionsChanged;
        protected Queue<N> queue;
        protected final N beginNode;
        protected final Collection<N> goalNodes;

        protected Iterator() {
            this.beginNode = ADStarForward.this.expander.makeNode(null, new Transition(null, ADStarForward.this.begin));
            this.goalNodes = new ArrayList(ADStarForward.this.goals.size());
            for (Object current : ADStarForward.this.goals) {
                this.goalNodes.add(ADStarForward.this.expander.makeNode(this.beginNode, new Transition(null, current)));
            }
            this.open = new HashMap();
            this.closed = new HashMap();
            this.incons = new HashMap();
            this.queue = new PriorityQueue();
            ADStarForward.this.expander.clearVisited();
            this.transitionsChanged = new HashSet();
            ADStarForward.this.expander.getVisited().put(this.beginNode.state(), this.beginNode);
            for (Object current : this.goalNodes) {
                ADStarForward.this.expander.getVisited().put(current.state(), current);
            }
            this.insertOpen(this.beginNode);
        }

        protected void insertOpen(N node) {
            this.open.put(node.state(), node);
            this.queue.offer(node);
        }

        protected N takePromising() {
            while (!this.queue.isEmpty()) {
                ADStarNode head = (ADStarNode)this.queue.peek();
                if (!this.open.containsKey(head.state())) {
                    this.queue.poll();
                    continue;
                }
                return head;
            }
            return null;
        }

        protected void updateQueues(N node) {
            Object state = node.state();
            if (node.getV().compareTo(node.getG()) != 0) {
                if (!this.closed.containsKey(state)) {
                    this.insertOpen(node);
                } else {
                    this.incons.put(state, node);
                }
            } else {
                this.open.remove(state);
                this.incons.remove(state);
            }
            node.setDoUpdate(false);
        }

        @Override
        public boolean hasNext() {
            return this.takePromising() != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public N next() {
            Object current = this.takePromising();
            Object state = current.state();
            ADStarNode minGoal = (ADStarNode)Collections.min(this.goalNodes);
            if (minGoal.compareTo(current) >= 0 || minGoal.getV().compareTo(minGoal.getG()) < 0) {
                this.open.remove(state);
                for (ADStarNode successorNode : ADStarForward.this.expander.expand(current)) {
                    if (!successorNode.isDoUpdate()) continue;
                    this.updateQueues(successorNode);
                }
                if (current.isConsistent()) {
                    current.setV(current.getG());
                    this.closed.put(state, current);
                } else {
                    ADStarForward.this.expander.setMaxV(current);
                    this.updateQueues(current);
                }
            } else {
                for (ADStarNode nodeTransitionsChanged : ADStarForward.this.expander.expandTransitionsChanged(this.beginNode.state(), current, this.transitionsChanged)) {
                    this.updateQueues(nodeTransitionsChanged);
                }
                this.open.putAll(this.incons);
                this.queue.clear();
                for (ADStarNode node : this.open.values()) {
                    this.queue.offer(node);
                }
                this.closed.clear();
            }
            return current;
        }

        public Map<S, N> getOpen() {
            return this.open;
        }

        public Map<S, N> getClosed() {
            return this.closed;
        }

        public Map<S, N> getIncons() {
            return this.incons;
        }
    }
}

