/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.algorithm;

import es.usc.citius.hipster.algorithm.Algorithm;
import es.usc.citius.hipster.model.HeuristicNode;
import es.usc.citius.hipster.model.function.NodeExpander;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;

public class AStar<A, S, C extends Comparable<C>, N extends HeuristicNode<A, S, C, N>>
extends Algorithm<A, S, N> {
    protected final N initialNode;
    protected final NodeExpander<A, S, N> expander;

    public AStar(N initialNode, NodeExpander<A, S, N> expander) {
        this.initialNode = initialNode;
        this.expander = expander;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public class Iterator
    implements java.util.Iterator<N> {
        protected Map<S, N> open = new HashMap();
        protected Map<S, N> closed = new HashMap();
        protected Queue<N> queue = new PriorityQueue();

        protected Iterator() {
            this.queue.add(AStar.this.initialNode);
            this.open.put(AStar.this.initialNode.state(), AStar.this.initialNode);
        }

        @Override
        public boolean hasNext() {
            return !this.open.values().isEmpty();
        }

        protected N takePromising() {
            HeuristicNode node = (HeuristicNode)this.queue.poll();
            while (!this.open.containsKey(node.state())) {
                node = (HeuristicNode)this.queue.poll();
            }
            return node;
        }

        @Override
        public N next() {
            Object current = this.takePromising();
            Object currentState = current.state();
            this.open.remove(currentState);
            for (HeuristicNode successorNode : AStar.this.expander.expand(current)) {
                HeuristicNode successorClose;
                HeuristicNode successorOpen = (HeuristicNode)this.open.get(successorNode.state());
                if (successorOpen != null && successorOpen.getScore().compareTo(successorNode.getScore()) <= 0 || (successorClose = (HeuristicNode)this.closed.get(successorNode.state())) != null && successorClose.getScore().compareTo(successorNode.getScore()) <= 0) continue;
                this.open.put(successorNode.state(), successorNode);
                this.queue.add(successorNode);
            }
            this.closed.put(currentState, current);
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Map<S, N> getOpen() {
            return this.open;
        }

        public void setOpen(Map<S, N> open) {
            this.open = open;
        }

        public Map<S, N> getClosed() {
            return this.closed;
        }

        public void setClosed(Map<S, N> closed) {
            this.closed = closed;
        }

        public Queue<N> getQueue() {
            return this.queue;
        }

        public void setQueue(Queue<N> queue) {
            this.queue = queue;
        }
    }
}

