/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.algorithm;

import es.usc.citius.hipster.model.Node;
import es.usc.citius.hipster.util.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class Algorithm<A, S, N extends Node<A, S, N>>
implements Iterable<N> {
    public SearchResult search(final S goalState) {
        return this.search(new Predicate<N>(){

            @Override
            public boolean apply(N n) {
                if (goalState != null) {
                    return n.state().equals(goalState);
                }
                return false;
            }
        });
    }

    public SearchResult search(Predicate<N> condition) {
        int iteration = 0;
        Iterator it = this.iterator();
        long begin = System.currentTimeMillis();
        Node currentNode = null;
        while (it.hasNext()) {
            ++iteration;
            currentNode = (Node)it.next();
            if (!condition.apply(currentNode)) continue;
        }
        long end = System.currentTimeMillis();
        return new SearchResult(this, currentNode, iteration, end - begin);
    }

    public void search(SearchListener<N> listener) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            listener.handle(it.next());
        }
    }

    public static <S, N extends Node<?, S, N>> List<S> recoverStatePath(N node) {
        LinkedList states = new LinkedList();
        for (Node n : node.path()) {
            states.add(n.state());
        }
        return states;
    }

    public static <A, N extends Node<A, ?, N>> List<A> recoverActionPath(N node) {
        LinkedList actions = new LinkedList();
        for (Node n : node.path()) {
            if (n.action() == null) continue;
            actions.add(n.action());
        }
        return actions;
    }

    public static interface SearchListener<N> {
        public void handle(N var1);
    }

    public final class SearchResult {
        private int iterations;
        private Collection<N> goalNodes;
        private long elapsed;
        final /* synthetic */ Algorithm this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public SearchResult(N iterations, int elapsed, long l) {
            void goalNode;
            this.this$0 = (Algorithm)this$0;
            this.goalNodes = Collections.singletonList(goalNode);
            this.iterations = (int)iterations;
            this.elapsed = elapsed;
        }

        public SearchResult(Algorithm this$0, Collection<N> goalNodes, int iterations, long elapsed) {
            this.this$0 = this$0;
            this.goalNodes = goalNodes;
            this.iterations = iterations;
            this.elapsed = elapsed;
        }

        public long getElapsed() {
            return this.elapsed;
        }

        public int getIterations() {
            return this.iterations;
        }

        public N getGoalNode() {
            return (Node)this.goalNodes.iterator().next();
        }

        public Collection<N> getGoalNodes() {
            return this.goalNodes;
        }

        public List<List<S>> getOptimalPaths() {
            ArrayList paths = new ArrayList(this.goalNodes.size());
            for (Node goalNode : this.goalNodes) {
                paths.add(Algorithm.recoverStatePath(goalNode));
            }
            return paths;
        }

        public String toString() {
            String ls = System.getProperty("line.separator");
            StringBuilder builder = new StringBuilder();
            builder.append("Total solutions: ").append(this.goalNodes.size()).append(ls);
            builder.append("Total time: ").append(this.getElapsed()).append(" ms").append(ls);
            builder.append("Total number of iterations: ").append(this.getIterations()).append(ls);
            int solution = 1;
            for (Node goalNode : this.goalNodes) {
                builder.append("+ Solution ").append(solution).append(": ").append(ls);
                builder.append(" - States: ").append(ls);
                builder.append("\t").append(Algorithm.recoverStatePath(goalNode).toString()).append(ls);
                builder.append(" - Actions: ").append(ls);
                builder.append("\t").append(Algorithm.recoverActionPath(goalNode).toString()).append(ls);
                builder.append(" - Search information: ").append(ls);
                builder.append("\t").append(goalNode.toString()).append(ls);
                ++solution;
            }
            return builder.toString();
        }
    }
}

