/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.algorithm;

import es.usc.citius.hipster.algorithm.Algorithm;
import es.usc.citius.hipster.algorithm.NegativeCycleException;
import es.usc.citius.hipster.model.CostNode;
import es.usc.citius.hipster.model.Node;
import es.usc.citius.hipster.model.function.NodeExpander;
import es.usc.citius.hipster.util.Predicate;
import es.usc.citius.lab.hipster.collections.HashQueue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;

public class BellmanFord<A, S, C extends Comparable<C>, N extends CostNode<A, S, C, N>>
extends Algorithm<A, S, N> {
    protected N initialNode;
    protected NodeExpander<A, S, N> nodeExpander;
    protected boolean checkNegativeCycles = true;

    public BellmanFord(N initialNode, NodeExpander<A, S, N> nodeExpander) {
        this.initialNode = initialNode;
        this.nodeExpander = nodeExpander;
    }

    @Override
    public Algorithm.SearchResult search(Predicate<N> condition) {
        int iteration = 0;
        Iterator it = this.iterator();
        long begin = System.currentTimeMillis();
        Object currentNode = null;
        Object goalNode = null;
        while (it.hasNext()) {
            ++iteration;
            currentNode = it.next();
            if (goalNode != null || !condition.apply(currentNode)) continue;
            goalNode = currentNode;
        }
        long end = System.currentTimeMillis();
        if (goalNode != null) {
            CostNode goal = (CostNode)it.explored.get(goalNode.state());
            return new Algorithm.SearchResult((Algorithm)this, (Node)goal, iteration, end - begin);
        }
        return new Algorithm.SearchResult(this, Collections.emptyList(), iteration, end - begin);
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public N getInitialNode() {
        return this.initialNode;
    }

    public void setInitialNode(N initialNode) {
        this.initialNode = initialNode;
    }

    public NodeExpander<A, S, N> getNodeExpander() {
        return this.nodeExpander;
    }

    public void setNodeExpander(NodeExpander<A, S, N> nodeExpander) {
        this.nodeExpander = nodeExpander;
    }

    public boolean isCheckNegativeCycles() {
        return this.checkNegativeCycles;
    }

    public void setCheckNegativeCycles(boolean checkNegativeCycles) {
        this.checkNegativeCycles = checkNegativeCycles;
    }

    public class Iterator
    implements java.util.Iterator<N> {
        protected Queue<S> queue = new HashQueue();
        protected Map<S, N> explored = new HashMap();

        protected Iterator() {
            this.queue.add(BellmanFord.this.initialNode.state());
            this.explored.put(BellmanFord.this.initialNode.state(), BellmanFord.this.initialNode);
        }

        protected void enqueue(N node) {
            Object state = node.state();
            if (!this.queue.contains(state)) {
                this.queue.add(state);
            }
            this.explored.put(state, node);
        }

        protected N dequeue() {
            Object state = this.queue.poll();
            return (CostNode)this.explored.get(state);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public N next() {
            Object currentNode = this.dequeue();
            if (BellmanFord.this.checkNegativeCycles && currentNode.pathSize() > this.explored.size()) {
                throw new NegativeCycleException();
            }
            for (CostNode successor : BellmanFord.this.nodeExpander.expand(currentNode)) {
                CostNode previousNode = (CostNode)this.explored.get(successor.state());
                if (previousNode != null) {
                    if (successor.getCost().compareTo(previousNode.getCost()) >= 0) continue;
                    this.enqueue(successor);
                    continue;
                }
                this.enqueue(successor);
            }
            return currentNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

