/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.algorithm;

import es.usc.citius.hipster.algorithm.Algorithm;
import es.usc.citius.hipster.model.Node;
import es.usc.citius.hipster.model.function.NodeExpander;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class BreadthFirstSearch<A, S, N extends Node<A, S, N>>
extends Algorithm<A, S, N> {
    protected final N initialNode;
    protected final NodeExpander<A, S, N> expander;

    public BreadthFirstSearch(N initialNode, NodeExpander<A, S, N> expander) {
        this.initialNode = initialNode;
        this.expander = expander;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public class Iterator
    implements java.util.Iterator<N> {
        protected Queue<N> queue = new LinkedList();
        protected Map<S, N> visited = new HashMap();

        protected Iterator() {
            this.visited.put(BreadthFirstSearch.this.initialNode.state(), BreadthFirstSearch.this.initialNode);
            this.queue.add(BreadthFirstSearch.this.initialNode);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public N next() {
            Node current = (Node)this.queue.poll();
            for (Node successorNode : BreadthFirstSearch.this.expander.expand(current)) {
                if (this.visited.containsKey(successorNode.state())) continue;
                this.visited.put(successorNode.state(), successorNode);
                this.queue.add(successorNode);
            }
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Queue<N> getQueue() {
            return this.queue;
        }

        public void setQueue(Queue<N> queue) {
            this.queue = queue;
        }

        public Map<S, N> getVisited() {
            return this.visited;
        }

        public void setVisited(Map<S, N> visited) {
            this.visited = visited;
        }
    }
}

