/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.algorithm;

import es.usc.citius.hipster.algorithm.Algorithm;
import es.usc.citius.hipster.model.Node;
import es.usc.citius.hipster.model.function.NodeExpander;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;

public class DepthFirstSearch<A, S, N extends Node<A, S, N>>
extends Algorithm<A, S, N> {
    protected N initialNode;
    protected NodeExpander<A, S, N> expander;

    public DepthFirstSearch(N initialNode, NodeExpander<A, S, N> expander) {
        this.expander = expander;
        this.initialNode = initialNode;
    }

    @Override
    public java.util.Iterator<N> iterator() {
        return new Iterator();
    }

    public class Iterator
    implements java.util.Iterator<N> {
        protected Deque<StackFrameNode> stack = new ArrayDeque<StackFrameNode>();
        protected StackFrameNode next;
        protected Set<S> closed = new HashSet();
        protected boolean graphSupport = true;

        protected Iterator() {
            this.stack.addLast(new StackFrameNode(DepthFirstSearch.this, DepthFirstSearch.this.initialNode));
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.next = this.nextUnvisited();
                if (this.next == null) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public N next() {
            if (this.next != null) {
                StackFrameNode e = this.next;
                this.next = null;
                return e.node;
            }
            StackFrameNode nextUnvisited = this.nextUnvisited();
            if (nextUnvisited != null) {
                return nextUnvisited.node;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected StackFrameNode nextUnvisited() {
            StackFrameNode nextNode;
            while ((nextNode = this.processNextNode()) != null && (nextNode.processed || nextNode.visited || this.closed.contains(nextNode.node.state()))) {
            }
            if (nextNode != null) {
                nextNode.visited = true;
                if (this.graphSupport) {
                    this.closed.add(nextNode.node.state());
                }
            }
            return nextNode;
        }

        protected StackFrameNode processNextNode() {
            if (this.stack.isEmpty()) {
                return null;
            }
            StackFrameNode current = this.stack.peekLast();
            if (current.successors.hasNext()) {
                Node successor = (Node)current.successors.next();
                if (!this.graphSupport || !this.closed.contains(successor.state())) {
                    this.stack.addLast(new StackFrameNode(DepthFirstSearch.this, successor));
                }
                return current;
            }
            if (current.visited) {
                current.processed = true;
            }
            return this.stack.removeLast();
        }

        public Deque<StackFrameNode> getStack() {
            return this.stack;
        }

        public void setStack(Deque<StackFrameNode> stack) {
            this.stack = stack;
        }

        public StackFrameNode getNext() {
            return this.next;
        }

        public void setNext(StackFrameNode next) {
            this.next = next;
        }

        public Set<S> getClosed() {
            return this.closed;
        }

        public void setClosed(Set<S> closed) {
            this.closed = closed;
        }

        public boolean isGraphSupport() {
            return this.graphSupport;
        }

        public void setGraphSupport(boolean graphSupport) {
            this.graphSupport = graphSupport;
        }
    }

    public static class StackFrameNode {
        private java.util.Iterator<N> successors;
        private N node;
        boolean visited = false;
        boolean processed = false;
        final /* synthetic */ DepthFirstSearch this$0;

        StackFrameNode(java.util.Iterator successors, N node) {
            this.this$0 = this$0;
            this.successors = successors;
            this.node = node;
        }

        StackFrameNode(N node) {
            this.this$0 = this$0;
            this.node = node;
            this.successors = this$0.expander.expand(node).iterator();
        }

        public N getNode() {
            return this.node;
        }

        public java.util.Iterator<N> getSuccessors() {
            return this.successors;
        }

        public boolean isVisited() {
            return this.visited;
        }

        public boolean isProcessed() {
            return this.processed;
        }
    }
}

