/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.algorithm;

import es.usc.citius.hipster.algorithm.Algorithm;
import es.usc.citius.hipster.model.Node;
import es.usc.citius.hipster.model.function.NodeExpander;
import es.usc.citius.hipster.model.impl.UnweightedNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class DepthLimitedSearch<A, S, N extends Node<A, S, N>>
extends Algorithm<A, S, N> {
    protected N initialNode;
    protected N finalNode;
    protected NodeExpander nodeExpander;
    protected int maximumDepth;
    protected int currentDepth;
    protected ArrayList<S> path;

    public DepthLimitedSearch(N initialNode, N finalNode, NodeExpander nodeExpander, int maximumDepth) {
        this.initialNode = initialNode;
        this.finalNode = finalNode;
        this.nodeExpander = nodeExpander;
        this.maximumDepth = maximumDepth;
        this.currentDepth = 0;
        this.path = new ArrayList();
    }

    public int getMaximumDepth() {
        return this.maximumDepth;
    }

    public int getCurrentDepth() {
        return this.currentDepth;
    }

    public ArrayList<S> getPath() {
        return this.path;
    }

    public void incrementCurrentDepth() {
        ++this.currentDepth;
    }

    public boolean execute() {
        Stack<StackNode> nodeStack = new Stack<StackNode>();
        StackNode tempStackNode = new StackNode(this, this.initialNode);
        nodeStack.add(tempStackNode);
        while (!nodeStack.isEmpty()) {
            if (this.currentDepth <= this.maximumDepth) {
                StackNode temp = (StackNode)nodeStack.pop();
                if (!this.path.contains(temp.getNode()) && ((UnweightedNode)temp.getNode()).state().equals(((UnweightedNode)this.finalNode).state())) {
                    this.path.add(temp.getNode().state());
                    return true;
                }
                this.path.add(temp.getNode().state());
                for (StackNode child : temp.getChildren()) {
                    if (this.path.contains(child.getNode().state())) continue;
                    nodeStack.add(child);
                }
                this.incrementCurrentDepth();
                continue;
            }
            return false;
        }
        return false;
    }

    @Override
    public Iterator<N> iterator() {
        return null;
    }

    private static class StackNode {
        private N node;
        private Iterator<N> children;
        final /* synthetic */ DepthLimitedSearch this$0;

        public StackNode(N node) {
            this.this$0 = var1_1;
            this.node = node;
            this.children = var1_1.nodeExpander.expand(node).iterator();
        }

        public N getNode() {
            return this.node;
        }

        public void setNode(N node) {
            this.node = node;
        }

        public List<StackNode> getChildren() {
            ArrayList<StackNode> result = new ArrayList<StackNode>();
            while (this.children.hasNext()) {
                StackNode temp = new StackNode(this.this$0, (Node)this.children.next());
                result.add(temp);
            }
            return result;
        }

        public void setChildren(Iterator<N> children) {
            this.children = children;
        }
    }
}

