/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.algorithm;

import es.usc.citius.hipster.algorithm.ADStarForward;
import es.usc.citius.hipster.algorithm.AStar;
import es.usc.citius.hipster.algorithm.BellmanFord;
import es.usc.citius.hipster.algorithm.BreadthFirstSearch;
import es.usc.citius.hipster.algorithm.DepthFirstSearch;
import es.usc.citius.hipster.algorithm.DepthLimitedSearch;
import es.usc.citius.hipster.algorithm.IDAStar;
import es.usc.citius.hipster.algorithm.MultiobjectiveLS;
import es.usc.citius.hipster.algorithm.localsearch.AnnealingSearch;
import es.usc.citius.hipster.algorithm.localsearch.HillClimbing;
import es.usc.citius.hipster.model.CostNode;
import es.usc.citius.hipster.model.HeuristicNode;
import es.usc.citius.hipster.model.Node;
import es.usc.citius.hipster.model.function.impl.ADStarNodeExpander;
import es.usc.citius.hipster.model.function.impl.ADStarNodeFactory;
import es.usc.citius.hipster.model.impl.ADStarNodeImpl;
import es.usc.citius.hipster.model.problem.SearchComponents;
import es.usc.citius.hipster.model.problem.SearchProblem;
import java.util.Collections;

public final class Hipster {
    private Hipster() {
    }

    public static <A, S, C extends Comparable<C>, N extends HeuristicNode<A, S, C, N>> AStar<A, S, C, N> createAStar(SearchProblem<A, S, N> components) {
        return new AStar((HeuristicNode)components.getInitialNode(), components.getExpander());
    }

    public static <A, S, C extends Comparable<C>, N extends HeuristicNode<A, S, C, N>> AStar<A, S, C, N> createDijkstra(SearchProblem<A, S, N> components) {
        return new AStar((HeuristicNode)components.getInitialNode(), components.getExpander());
    }

    public static <A, S, C extends Comparable<C>, N extends CostNode<A, S, C, N>> BellmanFord<A, S, C, N> createBellmanFord(SearchProblem<A, S, N> components) {
        return new BellmanFord((CostNode)components.getInitialNode(), components.getExpander());
    }

    public static <A, S, N extends Node<A, S, N>> BreadthFirstSearch<A, S, N> createBreadthFirstSearch(SearchProblem<A, S, N> components) {
        return new BreadthFirstSearch<A, S, N>(components.getInitialNode(), components.getExpander());
    }

    public static <A, S, N extends Node<A, S, N>> DepthFirstSearch<A, S, N> createDepthFirstSearch(SearchProblem<A, S, N> components) {
        return new DepthFirstSearch<A, S, N>(components.getInitialNode(), components.getExpander());
    }

    public static <A, S, N extends Node<A, S, N>> DepthLimitedSearch<A, S, N> createDepthLimitedSearch(SearchProblem<A, S, N> components, int depth) {
        return new DepthLimitedSearch(components.getInitialNode(), components.getFinalNode(), components.getExpander(), depth);
    }

    public static <A, S, C extends Comparable<C>, N extends HeuristicNode<A, S, C, N>> IDAStar<A, S, C, N> createIDAStar(SearchProblem<A, S, N> components) {
        return new IDAStar((HeuristicNode)components.getInitialNode(), components.getExpander());
    }

    public static <A, S, C extends Comparable<C>, N extends HeuristicNode<A, S, C, N>> HillClimbing<A, S, C, N> createHillClimbing(SearchProblem<A, S, N> components, boolean enforced) {
        return new HillClimbing((HeuristicNode)components.getInitialNode(), components.getExpander(), enforced);
    }

    public static <A, S, N extends HeuristicNode<A, S, Double, N>> AnnealingSearch<A, S, N> createAnnealingSearch(SearchProblem<A, S, N> components, Double alpha, Double minTemp, AnnealingSearch.AcceptanceProbability acceptanceProbability, AnnealingSearch.SuccessorFinder<A, S, N> successorFinder) {
        return new AnnealingSearch<A, S, HeuristicNode>((HeuristicNode)components.getInitialNode(), components.getExpander(), alpha, minTemp, acceptanceProbability, successorFinder);
    }

    public static <A, S, C extends Comparable<C>, N extends HeuristicNode<A, S, C, N>> MultiobjectiveLS<A, S, C, N> createMultiobjectiveLS(SearchProblem<A, S, N> components) {
        return new MultiobjectiveLS((HeuristicNode)components.getInitialNode(), components.getExpander());
    }

    public static <A, S, C extends Comparable<C>> ADStarForward<A, S, C, ADStarNodeImpl<A, S, C>> createADStar(SearchComponents<A, S, C> components) {
        ADStarNodeFactory<A, S, C> factory = new ADStarNodeFactory<A, S, C>(components);
        ADStarNodeExpander<A, S, C, C> expander = new ADStarNodeExpander<A, S, C, C>(components, factory, 1.0);
        return new ADStarForward<A, S, C, C>(components.getBegin(), Collections.singleton(components.getGoal()), expander);
    }
}

