/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.algorithm;

import es.usc.citius.hipster.algorithm.DepthFirstSearch;
import es.usc.citius.hipster.model.HeuristicNode;
import es.usc.citius.hipster.model.Node;
import es.usc.citius.hipster.model.function.NodeExpander;

public class IDAStar<A, S, C extends Comparable<C>, N extends HeuristicNode<A, S, C, N>>
extends DepthFirstSearch<A, S, N> {
    public IDAStar(N initialNode, NodeExpander<A, S, N> expander) {
        super(initialNode, expander);
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public class Iterator
    extends DepthFirstSearch.Iterator {
        protected C fLimit;
        protected C minfLimit;
        protected int reinitialization;

        protected Iterator() {
            super(IDAStar.this);
            this.reinitialization = 0;
            this.fLimit = ((HeuristicNode)IDAStar.this.initialNode).getEstimation();
            this.minfLimit = null;
        }

        protected void updateMinFLimit(C currentFLimit) {
            if (this.minfLimit == null) {
                this.minfLimit = currentFLimit;
            } else if (this.minfLimit.compareTo(currentFLimit) > 0) {
                this.minfLimit = currentFLimit;
            }
        }

        @Override
        protected DepthFirstSearch.StackFrameNode nextUnvisited() {
            DepthFirstSearch.StackFrameNode nextNode;
            do {
                if ((nextNode = this.processNextNode()) != null || this.minfLimit == null || this.minfLimit.compareTo(this.fLimit) <= 0) continue;
                this.fLimit = this.minfLimit;
                ++this.reinitialization;
                this.minfLimit = null;
                super.getStack().addLast(new DepthFirstSearch.StackFrameNode((DepthFirstSearch)IDAStar.this, IDAStar.this.initialNode));
                nextNode = this.processNextNode();
            } while (nextNode != null && (nextNode.processed || nextNode.visited));
            if (nextNode != null) {
                nextNode.visited = true;
            }
            return nextNode;
        }

        @Override
        protected DepthFirstSearch.StackFrameNode processNextNode() {
            if (super.getStack().isEmpty()) {
                return null;
            }
            DepthFirstSearch.StackFrameNode current = this.stack.peekLast();
            Object fCurrent = ((HeuristicNode)current.getNode()).getScore();
            if (fCurrent.compareTo(this.fLimit) > 0) {
                this.updateMinFLimit(fCurrent);
                current.processed = true;
                return super.getStack().removeLast();
            }
            if (current.getSuccessors().hasNext()) {
                HeuristicNode successor = (HeuristicNode)current.getSuccessors().next();
                super.getStack().addLast(new DepthFirstSearch.StackFrameNode((DepthFirstSearch)IDAStar.this, (Node)successor));
                return current;
            }
            if (current.visited) {
                current.processed = true;
            }
            return super.getStack().removeLast();
        }

        public C getfLimit() {
            return this.fLimit;
        }

        public void setfLimit(C fLimit) {
            this.fLimit = fLimit;
        }

        public C getMinfLimit() {
            return this.minfLimit;
        }

        public void setMinfLimit(C minfLimit) {
            this.minfLimit = minfLimit;
        }

        public int getReinitialization() {
            return this.reinitialization;
        }

        public void setReinitialization(int reinitialization) {
            this.reinitialization = reinitialization;
        }
    }
}

