/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.algorithm;

import es.usc.citius.hipster.algorithm.Algorithm;
import es.usc.citius.hipster.model.HeuristicNode;
import es.usc.citius.hipster.model.function.NodeExpander;
import es.usc.citius.hipster.util.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;

public class MultiobjectiveLS<A, S, C extends Comparable<C>, N extends HeuristicNode<A, S, C, N>>
extends Algorithm<A, S, N> {
    protected N initialNode;
    protected NodeExpander<A, S, N> nodeExpander;

    public MultiobjectiveLS(N initialNode, NodeExpander<A, S, N> nodeExpander) {
        this.initialNode = initialNode;
        this.nodeExpander = nodeExpander;
    }

    @Override
    public Algorithm.SearchResult search(Predicate<N> condition) {
        int iteration = 0;
        Iterator it = new Iterator();
        long beginTime = System.currentTimeMillis();
        Object goalNode = null;
        while (it.hasNext()) {
            ++iteration;
            Object currentNode = it.next();
            if (!condition.apply(currentNode)) continue;
            goalNode = currentNode;
        }
        long elapsed = System.currentTimeMillis() - beginTime;
        if (goalNode != null) {
            Collection solutions = it.nonDominated.get(goalNode.state());
            return new Algorithm.SearchResult(this, solutions, iteration, elapsed);
        }
        return new Algorithm.SearchResult(this, Collections.emptyList(), iteration, elapsed);
    }

    @Override
    public java.util.Iterator<N> iterator() {
        return new Iterator();
    }

    public class Iterator
    implements java.util.Iterator<N> {
        protected Queue<N> queue = new LinkedList();
        public Map<S, Collection<N>> nonDominated;
        private final Collection<N> EMPTYLIST = new ArrayList();

        protected Iterator() {
            this.queue = new PriorityQueue();
            this.nonDominated = new HashMap();
            this.queue.add(MultiobjectiveLS.this.initialNode);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public N next() {
            HeuristicNode current = (HeuristicNode)this.queue.poll();
            for (HeuristicNode candidate : MultiobjectiveLS.this.nodeExpander.expand(current)) {
                Collection ndNodes = this.EMPTYLIST;
                if (!this.nonDominated.containsKey(candidate.state())) {
                    this.nonDominated.put(candidate.state(), new ArrayList());
                } else {
                    ndNodes = this.nonDominated.get(candidate.state());
                }
                if (this.isDominated(candidate, ndNodes)) continue;
                this.queue.add(candidate);
                ndNodes.add(candidate);
                for (HeuristicNode dominated : this.dominatedBy(candidate, ndNodes)) {
                    ndNodes.remove(dominated);
                }
            }
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected Collection<N> dominatedBy(N node, Iterable<N> nonDominated) {
            HashSet<HeuristicNode> dominated = new HashSet<HeuristicNode>();
            for (HeuristicNode n : nonDominated) {
                if (node.getScore().compareTo(n.getScore()) >= 0) continue;
                dominated.add(n);
            }
            return dominated;
        }

        protected boolean isDominated(N node, Iterable<N> nonDominated) {
            for (HeuristicNode nd : nonDominated) {
                if (nd.getScore().compareTo(node.getScore()) >= 0) continue;
                return true;
            }
            return false;
        }

        public Queue<N> getQueue() {
            return this.queue;
        }

        public Map<S, Collection<N>> getNonDominated() {
            return this.nonDominated;
        }
    }
}

